/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.model.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.shacl.model.SHPropertyShape;
import org.topbraid.shacl.model.SHRule;
import org.topbraid.shacl.model.SHShape;
import org.topbraid.shacl.model.impl.SHParameterizableInstanceImpl;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;

public abstract class SHShapeImpl
extends SHParameterizableInstanceImpl
implements SHShape {
    public SHShapeImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public Resource getPath() {
        return JenaUtil.getResourceProperty(this, SH.path);
    }

    @Override
    public List<SHPropertyShape> getPropertyShapes() {
        LinkedList<SHPropertyShape> results = new LinkedList<SHPropertyShape>();
        for (Statement s : this.listProperties(SH.parameter).toList()) {
            if (!s.getObject().isResource()) continue;
            results.add(SHFactory.asPropertyShape(s.getObject()));
        }
        for (Statement s : this.listProperties(SH.property).toList()) {
            if (!s.getObject().isResource()) continue;
            results.add(SHFactory.asPropertyShape(s.getObject()));
        }
        return results;
    }

    @Override
    public List<SHPropertyShape> getPropertyShapes(RDFNode predicate) {
        LinkedList<SHPropertyShape> results = new LinkedList<SHPropertyShape>();
        for (Resource property : JenaUtil.getResourceProperties(this, SH.parameter)) {
            if (!property.hasProperty(SH.path, predicate)) continue;
            results.add(SHFactory.asPropertyShape(property));
        }
        for (Resource property : JenaUtil.getResourceProperties(this, SH.property)) {
            if (!property.hasProperty(SH.path, predicate)) continue;
            results.add(SHFactory.asPropertyShape(property));
        }
        return results;
    }

    @Override
    public Iterable<SHRule> getRules() {
        LinkedList<SHRule> results = new LinkedList<SHRule>();
        for (Resource r : JenaUtil.getResourceProperties(this, SH.rule)) {
            results.add(r.as(SHRule.class));
        }
        return results;
    }

    @Override
    public Resource getSeverity() {
        Resource result2 = JenaUtil.getResourceProperty(this, SH.severity);
        return result2 != null ? result2 : SH.Violation;
    }

    @Override
    public boolean hasTargetNode(RDFNode node) {
        if (node instanceof Resource) {
            boolean shapeClass = JenaUtil.hasIndirectType(this, RDFS.Class);
            for (Resource type : JenaUtil.getAllTypes((Resource)node)) {
                if (shapeClass && type.equals(this)) {
                    return true;
                }
                if (!this.hasProperty(SH.targetClass, type)) continue;
                return true;
            }
        }
        if (node instanceof Resource) {
            for (Statement s : this.listProperties(SH.targetSubjectsOf).toList()) {
                if (!((Resource)node).hasProperty(JenaUtil.asProperty(s.getResource()))) continue;
                return true;
            }
        }
        for (Statement s : this.listProperties(SH.targetObjectsOf).toList()) {
            if (!node.getModel().contains(null, JenaUtil.asProperty(s.getResource()), node)) continue;
            return true;
        }
        if (this.hasProperty(SH.targetNode, node)) {
            return true;
        }
        for (Statement s : this.listProperties(SH.target).toList()) {
            if (!SHACLUtil.isInTarget(node, ARQFactory.get().getDataset(node.getModel()), s.getResource())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeactivated() {
        return this.hasProperty(SH.deactivated, JenaDatatypes.TRUE);
    }

    @Override
    public boolean isPropertyShape() {
        return this.hasProperty(SH.path);
    }
}

