/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.testcases;

import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.shacl.testcases.context.TestCaseContext;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaUtil;

public abstract class TestCase
implements Comparable<TestCase> {
    private Resource graph;
    private Resource resource;

    public TestCase(Resource graph, Resource resource) {
        this.graph = graph;
        this.resource = resource;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(TestCase other) {
        Resource env1 = JenaUtil.getResourceProperty(this.getResource(), DASH.testEnvironment);
        Resource env2 = JenaUtil.getResourceProperty(other.getResource(), DASH.testEnvironment);
        if (env1 != null) {
            Integer m2;
            String uri1 = env1.getURI();
            if (env2 == null) return 1;
            String uri2 = env2.getURI();
            int c = uri1.compareTo(uri2);
            if (c != 0) {
                return c;
            }
            Integer m1 = this.getResource().hasProperty(DASH.testModifiesEnvironment, JenaDatatypes.TRUE) ? 1 : 0;
            int m = m1.compareTo(m2 = Integer.valueOf(other.getResource().hasProperty(DASH.testModifiesEnvironment, JenaDatatypes.TRUE) ? 1 : 0));
            if (m == 0) return this.getResource().getURI().compareTo(other.getResource().getURI());
            return m;
        }
        if (env2 == null) return this.getResource().getURI().compareTo(other.getResource().getURI());
        return -1;
    }

    public Resource createFailure(Model results, String message) {
        Resource failure = this.createResult(results, DASH.FailureTestCaseResult);
        failure.addProperty(SH.resultMessage, message);
        return failure;
    }

    public Resource createFailure(Model results, String message, TestCaseContext context) {
        Resource failure = this.createResult(results, DASH.FailureTestCaseResult);
        failure.addProperty(SH.resultMessage, message + " (executed with " + context + ")");
        return failure;
    }

    protected Resource createResult(Model results, Resource type) {
        Resource result2 = results.createResource(type);
        result2.addProperty(DASH.testCase, this.resource);
        result2.addProperty(DASH.testGraph, this.graph);
        return result2;
    }

    public Resource getGraph() {
        return this.graph;
    }

    public Resource getResource() {
        return this.resource;
    }

    public abstract void run(Model var1) throws Exception;

    public boolean usesDifferentEnvironmentFrom(TestCase other) {
        if (this.getResource().hasProperty(DASH.testModifiesEnvironment)) {
            return true;
        }
        if (other.getResource().hasProperty(DASH.testModifiesEnvironment)) {
            return true;
        }
        Resource e1 = JenaUtil.getResourceProperty(this.getResource(), DASH.testEnvironment);
        Resource e2 = JenaUtil.getResourceProperty(other.getResource(), DASH.testEnvironment);
        if (e1 != null && e2 != null) {
            return !e1.equals(e2);
        }
        return e1 != null || e2 != null;
    }
}

