/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.js;

import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.shacl.arq.SHACLPaths;
import org.topbraid.shacl.engine.Constraint;
import org.topbraid.shacl.js.JSGraph;
import org.topbraid.shacl.js.JSScriptEngine;
import org.topbraid.shacl.js.NashornUtil;
import org.topbraid.shacl.js.SHACLScriptEngineManager;
import org.topbraid.shacl.js.model.JSFactory;
import org.topbraid.shacl.js.model.JSTerm;
import org.topbraid.shacl.model.SHJSExecutable;
import org.topbraid.shacl.util.FailureLog;
import org.topbraid.shacl.validation.ConstraintExecutor;
import org.topbraid.shacl.validation.ValidationEngine;
import org.topbraid.shacl.validation.js.SHACLObject;
import org.topbraid.shacl.vocabulary.DASH;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.statistics.SPINStatistics;
import org.topbraid.spin.statistics.SPINStatisticsManager;
import org.topbraid.spin.util.JenaUtil;

public abstract class AbstractJSExecutor
implements ConstraintExecutor {
    protected static final String SHACL = "SHACL";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeConstraint(Constraint constraint, ValidationEngine validationEngine, List<RDFNode> focusNodes) {
        JSScriptEngine jsEngine = SHACLScriptEngineManager.getCurrentEngine();
        Dataset dataset = validationEngine.getDataset();
        URI shapesGraphURI = validationEngine.getShapesGraphURI();
        String functionName = null;
        JSGraph shapesJSGraph = new JSGraph(dataset.getNamedModel(shapesGraphURI.toString()).getGraph(), jsEngine);
        Model dataModel = dataset.getDefaultModel();
        Object oldSHACL = jsEngine.get(SHACL);
        jsEngine.put(SHACL, new SHACLObject(shapesGraphURI, dataset));
        JSGraph dataJSGraph = new JSGraph(dataModel.getGraph(), jsEngine);
        try {
            jsEngine.put("$shapes", shapesJSGraph);
            jsEngine.put("$data", dataJSGraph);
            QuerySolutionMap bindings = new QuerySolutionMap();
            bindings.add(SH.currentShapeVar.getName(), constraint.getShapeResource());
            this.addBindings(constraint, bindings);
            SHJSExecutable executable = this.getExecutable(constraint);
            functionName = executable.getFunctionName();
            jsEngine.executeLibraries(executable);
            long startTime = System.currentTimeMillis();
            for (RDFNode theFocusNode : focusNodes) {
                bindings.add(SH.thisVar.getVarName(), theFocusNode);
                List<RDFNode> valueNodes = this.getValueNodes(validationEngine, constraint, bindings, theFocusNode);
                for (RDFNode valueNode : valueNodes) {
                    bindings.add("value", valueNode);
                    Object resultObj = jsEngine.invokeFunction(functionName, bindings);
                    this.handleJSResultObject(resultObj, validationEngine, constraint, theFocusNode, valueNode, executable, bindings);
                }
            }
            if (SPINStatisticsManager.get().isRecording()) {
                long endTime = System.currentTimeMillis();
                long duration = endTime - startTime;
                String label = this.getLabel(constraint);
                SPINStatistics stats = new SPINStatistics(label, null, duration, startTime, constraint.getComponent().asNode());
                SPINStatisticsManager.get().add(Collections.singletonList(stats));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Resource result2 = validationEngine.createResult(DASH.FailureResult, constraint, null);
            result2.addProperty(SH.resultMessage, "Could not execute JavaScript constraint");
            if (SH.JSConstraintComponent.equals(constraint.getComponent())) {
                result2.addProperty(SH.sourceConstraint, constraint.getParameterValue());
            }
            FailureLog.get().logFailure("Could not execute JavaScript function \"" + functionName + "\": " + ex);
        }
        finally {
            dataJSGraph.close();
            shapesJSGraph.close();
            jsEngine.put(SHACL, oldSHACL);
        }
    }

    protected abstract void addBindings(Constraint var1, QuerySolutionMap var2);

    protected abstract SHJSExecutable getExecutable(Constraint var1);

    protected abstract List<RDFNode> getValueNodes(ValidationEngine var1, Constraint var2, QuerySolutionMap var3, RDFNode var4);

    private void addDefaultMessages(ValidationEngine engine, Constraint constraint, Resource messageHolder, Resource fallback, Resource result2, QuerySolution bindings, Map resultObject) {
        if (constraint != null && constraint.getShapeResource().hasProperty(SH.message)) {
            for (Statement s : constraint.getShapeResource().listProperties(SH.message).toList()) {
                result2.addProperty(SH.resultMessage, s.getObject());
            }
        } else {
            boolean found = false;
            for (Statement s : messageHolder.listProperties(SH.message).toList()) {
                if (!s.getObject().isLiteral()) continue;
                QuerySolutionMap map = new QuerySolutionMap();
                map.addAll(bindings);
                if (resultObject != null) {
                    for (Object keyObject : resultObject.keySet()) {
                        Node valueNode;
                        String key = (String)keyObject;
                        RDFNode value = map.get(key);
                        if (value == null || (valueNode = JSFactory.getNode(value)) == null) continue;
                        map.add(key, result2.getModel().asRDFNode(valueNode));
                    }
                }
                engine.addResultMessage(result2, s.getLiteral(), map);
                found = true;
            }
            if (!found && fallback != null) {
                this.addDefaultMessages(engine, null, fallback, null, result2, bindings, resultObject);
            }
        }
    }

    private Resource createValidationResult(ValidationEngine engine, Constraint constraint, RDFNode focusNode) {
        Resource path;
        Resource result2 = engine.createResult(SH.ValidationResult, constraint, focusNode);
        if (SH.JSConstraintComponent.equals(constraint.getComponent())) {
            result2.addProperty(SH.sourceConstraint, constraint.getParameterValue());
        }
        if ((path = JenaUtil.getResourceProperty(constraint.getShapeResource(), SH.path)) != null) {
            result2.addProperty(SH.resultPath, SHACLPaths.clonePath(path, result2.getModel()));
        }
        return result2;
    }

    private void handleJSResultObject(Object resultObj, ValidationEngine engine, Constraint constraint, RDFNode focusNode, RDFNode valueNode, Resource messageHolder, QuerySolution bindings) throws Exception {
        if (NashornUtil.isArray(resultObj)) {
            for (Object ro : NashornUtil.asArray(resultObj)) {
                this.createValidationResultFromJSObject(engine, constraint, focusNode, messageHolder, bindings, ro);
            }
        } else if (resultObj instanceof Map) {
            this.createValidationResultFromJSObject(engine, constraint, focusNode, messageHolder, bindings, resultObj);
        } else if (resultObj instanceof Boolean) {
            if (!((Boolean)resultObj).booleanValue()) {
                Resource result2 = this.createValidationResult(engine, constraint, focusNode);
                if (valueNode != null) {
                    result2.addProperty(SH.value, valueNode);
                }
                this.addDefaultMessages(engine, constraint, messageHolder, constraint.getComponent(), result2, bindings, null);
            }
        } else if (resultObj instanceof String) {
            Resource result3 = this.createValidationResult(engine, constraint, focusNode);
            result3.addProperty(SH.resultMessage, (String)resultObj);
            if (valueNode != null) {
                result3.addProperty(SH.value, valueNode);
            }
            this.addDefaultMessages(engine, constraint, messageHolder, constraint.getComponent(), result3, bindings, null);
        }
    }

    private void createValidationResultFromJSObject(ValidationEngine engine, Constraint constraint, RDFNode focusNode, Resource messageHolder, QuerySolution bindings, Object ro) {
        Resource result2 = this.createValidationResult(engine, constraint, focusNode);
        if (ro instanceof Map) {
            Node pathNode;
            Object path;
            Object message;
            Node resultValueNode;
            Object value = ((Map)ro).get("value");
            if (value instanceof JSTerm && (resultValueNode = JSFactory.getNode(value)) != null) {
                result2.addProperty(SH.value, result2.getModel().asRDFNode(resultValueNode));
            }
            if ((message = ((Map)ro).get("message")) instanceof String) {
                result2.addProperty(SH.resultMessage, (String)message);
            }
            if ((path = ((Map)ro).get("path")) != null && (pathNode = JSFactory.getNode(path)) != null && pathNode.isURI()) {
                result2.addProperty(SH.resultPath, result2.getModel().asRDFNode(pathNode));
            }
        } else if (ro instanceof String) {
            result2.addProperty(SH.resultMessage, (String)ro);
        }
        if (!result2.hasProperty(SH.resultMessage)) {
            this.addDefaultMessages(engine, constraint, messageHolder, constraint.getComponent(), result2, bindings, ro instanceof Map ? (Map)ro : null);
        }
    }

    protected abstract String getLabel(Constraint var1);
}

