/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.validation.sparql;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitorFunction;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementVisitorBase;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.RecursiveElementVisitor;
import org.topbraid.shacl.vocabulary.SH;

public class SPARQLSyntaxChecker {
    public static List<String> checkQuery(Query query, final Set<String> preBoundVars) {
        final LinkedList<String> results = new LinkedList<String>();
        RecursiveElementVisitor elementVisitor = new RecursiveElementVisitor(new ElementVisitorBase()){

            @Override
            public void startElement(ElementBind el) {
                if (!(!preBoundVars.contains(el.getVar().getVarName()) || SH.valueVar.getVarName().equals(el.getVar().getVarName()) && el.getExpr().isVariable() && el.getExpr().asVar().equals(SH.thisVar))) {
                    results.add("Query must not reassign the pre-bound variable " + el.getVar() + " in a BIND clause");
                }
            }

            @Override
            public void startElement(ElementData el) {
                results.add("Query must not contain VALUES clause");
            }

            @Override
            public void startElement(ElementFilter el) {
                this.checkExpression(el.getExpr());
            }

            @Override
            public void startElement(ElementMinus el) {
                results.add("Query must not contain MINUS clause");
            }

            @Override
            public void startElement(ElementService el) {
                results.add("Query must not contain SERVICE clause");
            }

            @Override
            public void startElement(ElementSubQuery el) {
                if (el.getQuery().isQueryResultStar()) {
                    LinkedHashSet<Var> queryVars = new LinkedHashSet<Var>();
                    PatternVars.vars(queryVars, el.getQuery().getQueryPattern());
                    for (String varName : preBoundVars) {
                        if (SH.currentShapeVar.getVarName().equals(varName) || SH.shapesGraphVar.getVarName().equals(varName) || queryVars.contains(Var.alloc(varName))) continue;
                        results.add("Sub-query must return all potentially pre-bound variables including $" + varName);
                    }
                } else {
                    VarExprList project = el.getQuery().getProject();
                    for (String varName : preBoundVars) {
                        if (SH.currentShapeVar.getVarName().equals(varName) || SH.shapesGraphVar.getVarName().equals(varName) || project.contains(Var.alloc(varName))) continue;
                        results.add("Sub-query must return all potentially pre-bound variables including $" + varName);
                    }
                }
            }

            private void checkExpression(Expr expr) {
                final 1 parent = this;
                expr.visit(new ExprVisitorFunction(){

                    @Override
                    public void visit(ExprFunctionOp funcOp) {
                        if (funcOp.isGraphPattern()) {
                            funcOp.getElement().visit(parent);
                        }
                    }

                    @Override
                    public void visit(NodeValue nv) {
                    }

                    @Override
                    public void visit(ExprVar nv) {
                    }

                    @Override
                    public void visit(ExprAggregator eAgg) {
                    }

                    @Override
                    public void visit(ExprNone exprNone) {
                    }

                    @Override
                    protected void visitExprFunction(ExprFunction func) {
                        for (Expr expr : func.getArgs()) {
                            expr.visit(this);
                        }
                    }
                });
            }
        };
        query.getQueryPattern().visit(elementVisitor);
        return results;
    }
}

