/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.shacl.vocabulary;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.compose.MultiUnion;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.util.JenaUtil;

public class DASH {
    public static final String BASE_URI = "http://datashapes.org/dash";
    public static final String NAME = "DASH Data Shapes Vocabulary";
    public static final String NS = "http://datashapes.org/dash#";
    public static final String PREFIX = "dash";
    public static final Resource DefaultValueTypeRule = ResourceFactory.createResource("http://datashapes.org/dash#DefaultValueTypeRule");
    public static final Resource FailureResult = ResourceFactory.createResource("http://datashapes.org/dash#FailureResult");
    public static final Resource FailureTestCaseResult = ResourceFactory.createResource("http://datashapes.org/dash#FailureTestCaseResult");
    public static final Resource FunctionTestCase = ResourceFactory.createResource("http://datashapes.org/dash#FunctionTestCase");
    public static final Resource GraphUpdate = ResourceFactory.createResource("http://datashapes.org/dash#GraphUpdate");
    public static final Resource GraphValidationTestCase = ResourceFactory.createResource("http://datashapes.org/dash#GraphValidationTestCase");
    public static final Resource InferencingTestCase = ResourceFactory.createResource("http://datashapes.org/dash#InferencingTestCase");
    public static final Resource JSTestCase = ResourceFactory.createResource("http://datashapes.org/dash#JSTestCase");
    public static final Resource ListShape = ResourceFactory.createResource("http://datashapes.org/dash#ListShape");
    public static final Resource QueryTestCase = ResourceFactory.createResource("http://datashapes.org/dash#QueryTestCase");
    public static final Resource ParameterConstraintComponent = ResourceFactory.createResource("http://datashapes.org/dash#ParameterConstraintComponent");
    public static final Resource RDFQueryJSLibrary = ResourceFactory.createResource("http://datashapes.org/dash#RDFQueryJSLibrary");
    public static final Resource SPARQLUpdateSuggestionGenerator = ResourceFactory.createResource("http://datashapes.org/dash#SPARQLUpdateSuggestionGenerator");
    public static final Resource SuccessResult = ResourceFactory.createResource("http://datashapes.org/dash#SuccessResult");
    public static final Resource SuccessTestCaseResult = ResourceFactory.createResource("http://datashapes.org/dash#SuccessTestCaseResult");
    public static final Resource TestCase = ResourceFactory.createResource("http://datashapes.org/dash#TestCase");
    public static final Resource TestEnvironment = ResourceFactory.createResource("http://datashapes.org/dash#TestEnvironment");
    public static final Resource ValidationTestCase = ResourceFactory.createResource("http://datashapes.org/dash#ValidationTestCase");
    public static final Property abstract_ = ResourceFactory.createProperty("http://datashapes.org/dash#abstract");
    public static final Property addedTriple = ResourceFactory.createProperty("http://datashapes.org/dash#addedTriple");
    public static final Property cachable = ResourceFactory.createProperty("http://datashapes.org/dash#cachable");
    public static final Property composite = ResourceFactory.createProperty("http://datashapes.org/dash#composite");
    public static final Property defaultValueType = ResourceFactory.createProperty("http://datashapes.org/dash#defaultValueType");
    public static final Property deletedTriple = ResourceFactory.createProperty("http://datashapes.org/dash#deletedTriple");
    public static final Property expectedResult = ResourceFactory.createProperty("http://datashapes.org/dash#expectedResult");
    public static final Property expression = ResourceFactory.createProperty("http://datashapes.org/dash#expression");
    public static final Property includeSuggestions = ResourceFactory.createProperty("http://datashapes.org/dash#includeSuggestions");
    public static final Property node = ResourceFactory.createProperty("http://datashapes.org/dash#node");
    public static final Property private_ = ResourceFactory.createProperty("http://datashapes.org/dash#private");
    public static final Property propertySuggestionGenerator = ResourceFactory.createProperty("http://datashapes.org/dash#propertySuggestionGenerator");
    public static final Property rootClass = ResourceFactory.createProperty("http://datashapes.org/dash#rootClass");
    public static final Property suggestion = ResourceFactory.createProperty("http://datashapes.org/dash#suggestion");
    public static final Property suggestionGenerator = ResourceFactory.createProperty("http://datashapes.org/dash#suggestionGenerator");
    public static final Property suggestionGroup = ResourceFactory.createProperty("http://datashapes.org/dash#suggestionGroup");
    public static final Property testCase = ResourceFactory.createProperty("http://datashapes.org/dash#testCase");
    public static final Property testEnvironment = ResourceFactory.createProperty("http://datashapes.org/dash#testEnvironment");
    public static final Property testGraph = ResourceFactory.createProperty("http://datashapes.org/dash#testGraph");
    public static final Property testModifiesEnvironment = ResourceFactory.createProperty("http://datashapes.org/dash#testModifiesEnvironment");
    public static final Property validateShapes = ResourceFactory.createProperty("http://datashapes.org/dash#validateShapes");
    public static final Property x = ResourceFactory.createProperty("http://datashapes.org/dash#x");
    public static final Property y = ResourceFactory.createProperty("http://datashapes.org/dash#y");

    public static String getURI() {
        return NS;
    }

    public static Model createDefaultValueTypesModel(Model model) {
        String sparql = JenaUtil.getStringProperty(DefaultValueTypeRule.inModel(model), SH.construct);
        if (sparql == null) {
            throw new IllegalArgumentException("Shapes graph does not include tosh:" + DefaultValueTypeRule);
        }
        Model resultModel = JenaUtil.createMemoryModel();
        MultiUnion multiUnion = new MultiUnion(new Graph[]{model.getGraph(), resultModel.getGraph()});
        Model unionModel = ModelFactory.createModelForGraph(multiUnion);
        Query query = ARQFactory.get().createQuery(model, sparql);
        try (QueryExecution qexec = ARQFactory.get().createQueryExecution(query, unionModel);){
            qexec.execConstruct(resultModel);
            Model model2 = resultModel;
            return model2;
        }
    }
}

