/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.QuerySolutionMap;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetImpl;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingHashMap;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIterConcat;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.pfunction.PropFuncArg;
import org.apache.jena.sparql.pfunction.PropertyFunction;
import org.apache.jena.sparql.pfunction.PropertyFunctionBase;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.apache.jena.sparql.util.IterLib;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.arq.DatasetWithDifferentDefaultModel;
import org.topbraid.spin.arq.SPINARQFunction;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.system.MagicPropertyPolicy;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINARQPFunction
extends PropertyFunctionBase
implements PropertyFunctionFactory {
    public static final String SELECT_STAR_NOT_SUPPORTED_IN_MAGIC_PROPERTIES = "SELECT * not supported in magic properties";
    public static final String SELECT_WITH_EXPRESSIONS_NOT_SUPPORTED_IN_MAGIC_PROPERTIES = "SELECT with expressions not supported in magic properties";
    private Query arqQuery;
    private Query arqInverseQuery;
    private String queryString;
    private List<String> objectVarNames = new ArrayList<String>();

    public SPINARQPFunction(Function functionCls) {
        Select spinQuery = (Select)functionCls.getBody();
        this.queryString = ARQFactory.get().createCommandString(spinQuery);
        List<String> resultVariables = spinQuery.getResultVariableNames();
        if (resultVariables.isEmpty()) {
            throw new IllegalArgumentException(SELECT_STAR_NOT_SUPPORTED_IN_MAGIC_PROPERTIES);
        }
        for (String varName : resultVariables) {
            if (varName != null) {
                this.objectVarNames.add(varName);
                continue;
            }
            throw new IllegalArgumentException(SELECT_WITH_EXPRESSIONS_NOT_SUPPORTED_IN_MAGIC_PROPERTIES);
        }
        int selectStart = this.queryString.indexOf("SELECT ");
        int eol = this.queryString.indexOf(10, selectStart);
        StringBuffer sb = new StringBuffer(this.queryString.substring(0, eol));
        List<Argument> arguments = functionCls.getArguments(true);
        for (Argument arg : arguments) {
            sb.append(" ?");
            sb.append(arg.getVarName());
        }
        sb.append(this.queryString.substring(eol));
        try {
            this.arqQuery = ARQFactory.get().createQuery(sb.toString());
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Magic property " + functionCls + " does not contain a valid body. Internally used query string:\n" + sb, ex);
        }
        Resource spinInverseQuery = functionCls.getPropertyResourceValue(SPIN.inverseBody);
        if (spinInverseQuery != null) {
            String inverseQueryString = ARQFactory.get().createCommandString(SPINFactory.asCommand(spinInverseQuery));
            int inverseSelectStart = inverseQueryString.indexOf("SELECT ");
            int inverseEol = inverseQueryString.indexOf(10, inverseSelectStart);
            StringBuffer isb = new StringBuffer(inverseQueryString.substring(0, inverseEol));
            isb.append(" ?object ");
            isb.append(inverseQueryString.substring(inverseEol));
            try {
                this.arqInverseQuery = ARQFactory.get().createQuery(isb.toString());
            }
            catch (Exception ex) {
                throw new IllegalArgumentException("Magic property " + functionCls + " does not contain a valid inverse body. Internally used query string:\n" + isb, ex);
            }
        }
    }

    @Override
    public PropertyFunction create(String arg0) {
        return this;
    }

    @Override
    public QueryIterator exec(Binding inputBinding, PropFuncArg argSubject, Node predicate, PropFuncArg argObject, ExecutionContext context) {
        argObject = Substitute.substitute(argObject, inputBinding);
        argSubject = Substitute.substitute(argSubject, inputBinding);
        ExprList subjectExprList = argSubject.asExprList();
        ExprList objectExprList = argObject.asExprList();
        QueryIterConcat existingValues = null;
        MagicPropertyPolicy.Policy policy = MagicPropertyPolicy.Policy.QUERY_RESULTS_ONLY;
        Query theQuery = this.arqQuery;
        if (this.arqInverseQuery != null && objectExprList.size() == 1 && objectExprList.get(0).isConstant()) {
            theQuery = this.arqInverseQuery;
        }
        if (objectExprList.size() == 1 && subjectExprList.size() == 1) {
            Expr subject = subjectExprList.get(0);
            Expr object = objectExprList.get(0);
            if (subject.isVariable() || object.isVariable()) {
                Node n;
                Node matchSubject = null;
                if (subject.isConstant() && ((n = subject.getConstant().asNode()).isURI() || n.isBlank())) {
                    matchSubject = n;
                }
                Node matchObject = null;
                if (object.isConstant()) {
                    matchObject = object.getConstant().asNode();
                }
                Graph queryGraph = context.getActiveGraph();
                policy = MagicPropertyPolicy.get().getPolicy(predicate.getURI(), queryGraph, matchSubject, matchObject);
                if (policy != MagicPropertyPolicy.Policy.QUERY_RESULTS_ONLY) {
                    ExtendedIterator<Triple> it = queryGraph.find(matchSubject, predicate, matchObject);
                    while (it.hasNext()) {
                        Triple triple = (Triple)it.next();
                        BindingHashMap map = new BindingHashMap(inputBinding);
                        if (subject.isVariable()) {
                            map.add(subject.asVar(), triple.getSubject());
                        }
                        if (object.isVariable()) {
                            map.add(object.asVar(), triple.getObject());
                        }
                        if (existingValues == null) {
                            existingValues = new QueryIterConcat(context);
                        }
                        QueryIterator nested = IterLib.result(map, context);
                        existingValues.add(nested);
                    }
                }
            }
        }
        if (policy != MagicPropertyPolicy.Policy.TRIPLES_ONLY) {
            NodeValue x;
            Var var;
            Graph activeGraph = context.getActiveGraph();
            if (activeGraph == null) {
                activeGraph = JenaUtil.createDefaultGraph();
            }
            Model model = ModelFactory.createModelForGraph(activeGraph);
            Node t = inputBinding.get(Var.alloc("this"));
            QuerySolutionMap bindings = new QuerySolutionMap();
            if (t != null) {
                bindings.add("this", model.asRDFNode(t));
            }
            HashMap<String, Var> vars = new HashMap<String, Var>();
            if (theQuery == this.arqInverseQuery) {
                NodeValue x2 = objectExprList.get(0).getConstant();
                bindings.add("object", model.asRDFNode(x2.asNode()));
            } else {
                for (int i = 0; i < this.objectVarNames.size() && i < objectExprList.size(); ++i) {
                    Expr expr = objectExprList.get(i);
                    String objectVarName = this.objectVarNames.get(i);
                    if (expr.isVariable() && !inputBinding.contains(expr.asVar())) {
                        var = expr.asVar();
                        vars.put(objectVarName, var);
                        continue;
                    }
                    x = expr.eval(inputBinding, context);
                    if (x == null) continue;
                    bindings.add(objectVarName, model.asRDFNode(x.asNode()));
                }
            }
            for (int i = 0; i < subjectExprList.size(); ++i) {
                String subjectVarName = "arg" + (i + 1);
                Expr expr = subjectExprList.get(i);
                if (expr.isVariable() && !inputBinding.contains(expr.asVar())) {
                    var = expr.asVar();
                    vars.put(subjectVarName, var);
                    continue;
                }
                x = expr.eval(inputBinding, context);
                if (x == null) continue;
                bindings.add(subjectVarName, model.asRDFNode(x.asNode()));
            }
            DatasetWithDifferentDefaultModel ds = context.getDataset() != null ? new DatasetWithDifferentDefaultModel(model, DatasetImpl.wrap(context.getDataset())) : null;
            QueryExecution qexec = ds != null ? ARQFactory.get().createQueryExecution(theQuery, ds, (QuerySolution)bindings) : ARQFactory.get().createQueryExecution(theQuery, model);
            ResultSet rs = qexec.execSelect();
            List<Var> rvs = theQuery.getProjectVars();
            Iterator<Binding> x3 = Iter.map(rs, qs -> SPINARQPFunction.convertRow(qs, vars, rvs, inputBinding));
            QueryIterPlainWrapper it0 = new QueryIterPlainWrapper(x3, context);
            QueryIterator it = QueryIteratorClosing.protect(it0, qexec);
            if (existingValues != null) {
                existingValues.add(it);
                return existingValues;
            }
            return it;
        }
        if (existingValues != null) {
            return existingValues;
        }
        return IterLib.result(inputBinding, context);
    }

    private static Binding convertRow(QuerySolution row, Map<String, Var> vars, List<Var> rvs, Binding parentBinding) {
        BindingMap result2 = BindingFactory.create(parentBinding);
        for (Var var1 : rvs) {
            Var var2;
            RDFNode resultNode = row.get(var1.getVarName());
            if (resultNode == null || (var2 = vars.get(var1.getVarName())) == null) continue;
            result2.add(var2, resultNode.asNode());
        }
        return result2;
    }

    private static class QueryIteratorClosing
    extends QueryIteratorWrapper {
        private final AutoCloseable closeable;

        static QueryIterator protect(QueryIterator qIter, AutoCloseable closeable) {
            if (qIter instanceof QueryIteratorClosing) {
                Log.warn(SPINARQFunction.class, "Wrapping an already wrapped QueryIteratorClosing");
            }
            return new QueryIteratorClosing(qIter, closeable);
        }

        private QueryIteratorClosing(QueryIterator qIter, AutoCloseable closeable) {
            super(qIter);
            this.closeable = closeable;
        }

        @Override
        protected boolean hasNextBinding() {
            try {
                return super.hasNextBinding();
            }
            catch (RuntimeException ex) {
                this.closeInternal();
                throw ex;
            }
        }

        @Override
        protected Binding moveToNextBinding() {
            try {
                return super.moveToNextBinding();
            }
            catch (RuntimeException ex) {
                this.closeInternal();
                throw ex;
            }
        }

        @Override
        protected void closeIterator() {
            this.closeInternal();
            super.closeIterator();
        }

        @Override
        protected void requestCancel() {
            this.closeInternal();
            super.requestCancel();
        }

        private void closeInternal() {
            try {
                this.closeable.close();
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unexpected checked exception", ex);
            }
        }
    }
}

