/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.arq;

import java.util.HashMap;
import java.util.Map;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.pfunction.PropertyFunctionFactory;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.arq.SPINARQPFunction;
import org.topbraid.spin.arq.SPINARQPFunctionFactory;
import org.topbraid.spin.arq.SPINFunctionDrivers;
import org.topbraid.spin.arq.SPINFunctionFactory;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SPIN;

public class SPINThreadFunctions {
    private Map<String, FunctionFactory> functionsCache = new HashMap<String, FunctionFactory>();
    private Map<String, PropertyFunctionFactory> pfunctionsCache = new HashMap<String, PropertyFunctionFactory>();
    private Model model;

    SPINThreadFunctions(Model model) {
        this.model = model;
    }

    FunctionFactory getFunctionFactory(String uri) {
        FunctionFactory old = this.functionsCache.get(uri);
        if (old != null) {
            return old;
        }
        if (this.functionsCache.containsKey(uri)) {
            return null;
        }
        return this.getFunctionFactoryFromModel(uri);
    }

    PropertyFunctionFactory getPFunctionFactory(String uri) {
        PropertyFunctionFactory old = this.pfunctionsCache.get(uri);
        if (old != null) {
            return old;
        }
        if (this.pfunctionsCache.containsKey(uri)) {
            return null;
        }
        return this.getPropertyFunctionFactoryFromModel(uri);
    }

    private FunctionFactory getFunctionFactoryFromModel(String uri) {
        SPINFunctionFactory arqFunction;
        Function spinFunction = this.model.getResource(uri).as(Function.class);
        if (JenaUtil.hasIndirectType(spinFunction, SPIN.Function)) {
            SPINFunctionFactory arqFunction2 = SPINFunctionDrivers.get().create(spinFunction);
            if (arqFunction2 != null) {
                this.functionsCache.put(uri, arqFunction2);
                return arqFunction2;
            }
        } else if (JenaUtil.hasIndirectType(spinFunction, SH.Function) && (arqFunction = SPINFunctionDrivers.get().create(spinFunction)) != null) {
            this.functionsCache.put(uri, arqFunction);
            return arqFunction;
        }
        this.functionsCache.put(uri, null);
        return null;
    }

    private PropertyFunctionFactory getPropertyFunctionFactoryFromModel(String uri) {
        Function spinFunction = this.model.getResource(uri).as(Function.class);
        if (JenaUtil.hasIndirectType(spinFunction, SPIN.MagicProperty) && spinFunction.hasProperty(SPIN.body)) {
            SPINARQPFunction arqFunction = SPINARQPFunctionFactory.get().create(spinFunction);
            this.pfunctionsCache.put(uri, arqFunction);
            return arqFunction;
        }
        this.pfunctionsCache.put(uri, null);
        return null;
    }
}

