/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.inference;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.graph.Capabilities;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphEventManager;
import org.apache.jena.graph.GraphStatisticsHandler;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.GraphWithPerform;
import org.apache.jena.shared.AddDeniedException;
import org.apache.jena.shared.DeleteDeniedException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;

class ControlledUpdateGraph
implements GraphWithPerform {
    private Graph delegate;
    private Set<Triple> addedTriples = new HashSet<Triple>();
    private Set<Triple> deletedTriples = new HashSet<Triple>();

    ControlledUpdateGraph(Graph delegate) {
        this.delegate = delegate;
    }

    @Override
    public void add(Triple t) throws AddDeniedException {
        this.performAdd(t);
    }

    @Override
    public void clear() {
        for (Triple triple : this.find(Node.ANY, Node.ANY, Node.ANY).toList()) {
            this.delete(triple);
        }
    }

    @Override
    public boolean dependsOn(Graph other) {
        return this.delegate.dependsOn(other);
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return this.delegate.getTransactionHandler();
    }

    @Override
    public Capabilities getCapabilities() {
        return this.delegate.getCapabilities();
    }

    @Override
    public GraphEventManager getEventManager() {
        return this.delegate.getEventManager();
    }

    @Override
    public GraphStatisticsHandler getStatisticsHandler() {
        return this.delegate.getStatisticsHandler();
    }

    @Override
    public PrefixMapping getPrefixMapping() {
        return this.delegate.getPrefixMapping();
    }

    @Override
    public void delete(Triple t) throws DeleteDeniedException {
        this.performDelete(t);
    }

    @Override
    public ExtendedIterator<Triple> find(Triple m) {
        return this.delegate.find(m);
    }

    @Override
    public ExtendedIterator<Triple> find(Node s, Node p, Node o) {
        return this.delegate.find(s, p, o);
    }

    @Override
    public boolean isIsomorphicWith(Graph g) {
        return this.delegate.isIsomorphicWith(g);
    }

    @Override
    public boolean contains(Node s, Node p, Node o) {
        return this.delegate.contains(s, p, o);
    }

    @Override
    public boolean contains(Triple t) {
        return this.delegate.contains(t);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    @Override
    public void performAdd(Triple t) {
        if (!this.delegate.contains(t)) {
            this.addedTriples.add(t);
        }
        this.delegate.add(t);
    }

    @Override
    public void performDelete(Triple t) {
        if (this.delegate.contains(t)) {
            this.deletedTriples.add(t);
        }
        this.delegate.delete(t);
    }

    @Override
    public void remove(Node s, Node p, Node o) {
        for (Triple triple : this.find(s, p, o).toList()) {
            this.delete(triple);
        }
    }

    public Iterable<Triple> getAddedTriples() {
        return this.addedTriples;
    }

    public boolean isChanged() {
        return !this.addedTriples.isEmpty() || !this.deletedTriples.isEmpty();
    }
}

