/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.internal;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.visitor.AbstractTriplesVisitor;
import org.topbraid.spin.vocabulary.SPIN;

public class ObjectPropertiesGetter
extends AbstractTriplesVisitor {
    private Set<Property> properties = new HashSet<Property>();
    private Model targetModel;

    public ObjectPropertiesGetter(Model targetModel, Element element, Map<Property, RDFNode> initialBindings) {
        super(element, initialBindings);
        this.targetModel = targetModel;
    }

    public Set<Property> getResults() {
        return this.properties;
    }

    @Override
    protected void handleTriplePattern(TriplePattern triplePattern, Map<Property, RDFNode> bindings) {
        Resource predicate;
        Variable var;
        boolean valid = false;
        RDFNode subject = triplePattern.getSubject();
        if (SPIN._this.equals(subject)) {
            valid = true;
        } else if (bindings != null && (var = SPINFactory.asVariable(subject)) != null) {
            String varName = var.getName();
            for (Property argPredicate : bindings.keySet()) {
                RDFNode b;
                if (!varName.equals(argPredicate.getLocalName()) || !SPIN._this.equals(b = bindings.get(argPredicate))) continue;
                valid = true;
                break;
            }
        }
        if (valid && (predicate = triplePattern.getPredicate()) != null) {
            Variable variable = SPINFactory.asVariable(predicate);
            if (variable == null) {
                String uri = predicate.getURI();
                if (uri != null) {
                    this.properties.add(this.targetModel.getProperty(uri));
                }
            } else if (bindings != null) {
                String varName = variable.getName();
                for (Property argPredicate : bindings.keySet()) {
                    RDFNode b;
                    if (!varName.equals(argPredicate.getLocalName()) || (b = bindings.get(argPredicate)) == null || !b.isURIResource()) continue;
                    String uri = ((Resource)b).getURI();
                    this.properties.add(this.targetModel.getProperty(uri));
                }
            }
        }
    }
}

