/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Statement;
import org.topbraid.spin.model.Bind;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.ElementImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.vocabulary.SP;

public class BindImpl
extends ElementImpl
implements Bind {
    public BindImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public RDFNode getExpression() {
        Statement s = this.getProperty(SP.expression);
        if (s != null) {
            return SPINFactory.asExpression(s.getObject());
        }
        return null;
    }

    @Override
    public Variable getVariable() {
        Statement s = this.getProperty(SP.variable);
        if (s != null && s.getObject().isResource()) {
            return s.getResource().as(Variable.class);
        }
        return null;
    }

    @Override
    public void print(PrintContext context) {
        context.printKeyword("BIND");
        context.print(" ");
        this.printVariableExpression(context, this.getVariable(), this.getExpression());
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

