/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.model.NamedGraph;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.ElementImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.visitor.ElementVisitor;
import org.topbraid.spin.vocabulary.SP;

public class NamedGraphImpl
extends ElementImpl
implements NamedGraph {
    public NamedGraphImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public Resource getNameNode() {
        Resource r = this.getResource(SP.graphNameNode);
        if (r != null) {
            Variable variable = SPINFactory.asVariable(r);
            if (variable != null) {
                return variable;
            }
            return r;
        }
        return null;
    }

    @Override
    public void print(PrintContext p) {
        p.printKeyword("GRAPH");
        p.print(" ");
        NamedGraphImpl.printVarOrResource(p, this.getNameNode());
        this.printNestedElementList(p);
    }

    @Override
    public void visit(ElementVisitor visitor) {
        visitor.visit(this);
    }
}

