/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.vocabulary.RDF;
import org.topbraid.spin.arq.ARQ2SPIN;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.SolutionModifierQuery;
import org.topbraid.spin.model.Values;
import org.topbraid.spin.model.impl.AbstractSPINResourceImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.Printable;
import org.topbraid.spin.util.JenaUtil;
import org.topbraid.spin.vocabulary.SP;

public abstract class QueryImpl
extends AbstractSPINResourceImpl
implements SolutionModifierQuery {
    public QueryImpl(Node node, EnhGraph graph) {
        super(node, graph);
    }

    @Override
    public List<String> getFrom() {
        return this.getStringList(SP.from);
    }

    @Override
    public List<String> getFromNamed() {
        return this.getStringList(SP.fromNamed);
    }

    @Override
    public Long getLimit() {
        return this.getLong(SP.limit);
    }

    @Override
    public Long getOffset() {
        return this.getLong(SP.offset);
    }

    private List<String> getStringList(Property predicate) {
        LinkedList<String> results = new LinkedList<String>();
        StmtIterator it = this.listProperties(predicate);
        while (it.hasNext()) {
            RDFNode node = it.nextStatement().getObject();
            if (node.isLiteral()) {
                results.add(((Literal)node).getLexicalForm());
                continue;
            }
            if (!node.isURIResource()) continue;
            results.add(((Resource)node).getURI());
        }
        return results;
    }

    @Override
    public Values getValues() {
        Resource values = JenaUtil.getResourceProperty(this, SP.values);
        if (values != null) {
            return values.as(Values.class);
        }
        return null;
    }

    @Override
    public ElementList getWhere() {
        Statement whereS = this.getProperty(SP.where);
        if (whereS != null) {
            Element element = SPINFactory.asElement(whereS.getResource());
            return (ElementList)element;
        }
        return null;
    }

    @Override
    public List<Element> getWhereElements() {
        return this.getElements(SP.where);
    }

    @Override
    public void print(PrintContext p) {
        String text = ARQ2SPIN.getTextOnly(this);
        if (text != null) {
            if (p.hasInitialBindings()) {
                throw new IllegalArgumentException("Queries that only have an sp:text cannot be converted to a query string if initial bindings are present.");
            }
            p.print(text);
        } else {
            this.printSPINRDF(p);
        }
    }

    protected abstract void printSPINRDF(PrintContext var1);

    protected void printStringFrom(PrintContext context) {
        for (String from : this.getFrom()) {
            context.println();
            context.printKeyword("FROM");
            context.print(" <");
            context.print(from);
            context.print(">");
        }
        for (String fromNamed : this.getFromNamed()) {
            context.println();
            context.printKeyword("FROM NAMED");
            context.print(" <");
            context.print(fromNamed);
            context.print(">");
        }
    }

    protected void printSolutionModifiers(PrintContext context) {
        Long offset;
        Long limit;
        List<RDFNode> orderBy = this.getList(SP.orderBy);
        if (!orderBy.isEmpty()) {
            context.println();
            context.printIndentation(context.getIndentation());
            context.printKeyword("ORDER BY");
            for (RDFNode node : orderBy) {
                RDFNode expression;
                if (!node.isResource()) continue;
                Resource resource = (Resource)node;
                if (resource.hasProperty(RDF.type, SP.Asc)) {
                    context.print(" ");
                    context.printKeyword("ASC");
                    context.print(" ");
                    expression = resource.getProperty(SP.expression).getObject();
                    this.printOrderByExpression(context, expression);
                    continue;
                }
                if (resource.hasProperty(RDF.type, SP.Desc)) {
                    context.print(" ");
                    context.printKeyword("DESC");
                    context.print(" ");
                    expression = resource.getProperty(SP.expression).getObject();
                    this.printOrderByExpression(context, expression);
                    continue;
                }
                context.print(" ");
                this.printOrderByExpression(context, node);
            }
        }
        if ((limit = this.getLimit()) != null) {
            context.println();
            context.printIndentation(context.getIndentation());
            context.printKeyword("LIMIT");
            context.print(" " + limit);
        }
        if ((offset = this.getOffset()) != null) {
            context.println();
            context.printIndentation(context.getIndentation());
            context.print("OFFSET");
            context.print(" " + offset);
        }
    }

    private void printOrderByExpression(PrintContext sb, RDFNode node) {
        if (node instanceof Resource) {
            Resource resource = (Resource)node;
            Printable printable = SPINFactory.asAggregation(resource);
            if (printable == null) {
                printable = SPINFactory.asFunctionCall(resource);
            }
            if (printable != null) {
                sb.print("(");
                PrintContext pc = sb.clone();
                pc.setNested(true);
                printable.print(pc);
                sb.print(")");
                return;
            }
        }
        this.printNestedExpressionString(sb, node, true);
    }

    protected void printValues(PrintContext p) {
        Values values = this.getValues();
        if (values != null) {
            p.println();
            values.print(p);
        }
    }

    protected void printWhere(PrintContext p) {
        p.printIndentation(p.getIndentation());
        p.printKeyword("WHERE");
        this.printNestedElementList(p, SP.where);
    }
}

