/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.model.impl;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.topbraid.spin.arq.ARQ2SPIN;
import org.topbraid.spin.arq.ARQFactory;
import org.topbraid.spin.model.Aggregation;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.QueryImpl;
import org.topbraid.spin.model.print.PrintContext;
import org.topbraid.spin.model.print.Printable;
import org.topbraid.spin.vocabulary.SP;

public class SelectImpl
extends QueryImpl
implements Select {
    public SelectImpl(Node node, EnhGraph eh) {
        super(node, eh);
    }

    @Override
    public List<String> getResultVariableNames() {
        if (this.hasProperty(SP.resultVariables)) {
            LinkedList<String> results = new LinkedList<String>();
            for (Resource item : this.getResultVariables()) {
                if (item instanceof Variable) {
                    results.add(((Variable)item).getName());
                    continue;
                }
                results.add(null);
            }
            return results;
        }
        String text = ARQ2SPIN.getTextOnly(this);
        if (text != null) {
            Query arqQuery = ARQFactory.get().createQuery(this);
            return arqQuery.getResultVars();
        }
        return Collections.emptyList();
    }

    @Override
    public List<Resource> getResultVariables() {
        LinkedList<Resource> results = new LinkedList<Resource>();
        for (RDFNode node : this.getList(SP.resultVariables)) {
            RDFNode e2 = SPINFactory.asExpression(node);
            results.add((Resource)e2);
        }
        return results;
    }

    @Override
    public boolean isDistinct() {
        return this.hasProperty(SP.distinct, this.getModel().createTypedLiteral(true));
    }

    @Override
    public boolean isReduced() {
        return this.hasProperty(SP.reduced, this.getModel().createTypedLiteral(true));
    }

    @Override
    public void printSPINRDF(PrintContext p) {
        List<Resource> vars;
        this.printComment(p);
        this.printPrefixes(p);
        p.printIndentation(p.getIndentation());
        p.printKeyword("SELECT");
        p.print(" ");
        if (this.isDistinct()) {
            p.printKeyword("DISTINCT");
            p.print(" ");
        }
        if (this.isReduced()) {
            p.printKeyword("REDUCED");
            p.print(" ");
        }
        if ((vars = this.getResultVariables()).isEmpty()) {
            p.print("*");
        } else {
            Iterator<Resource> vit = vars.iterator();
            while (vit.hasNext()) {
                Resource var = vit.next();
                if (var instanceof Variable) {
                    this.printVariableExpression(p, (Variable)var);
                } else if (var instanceof Aggregation) {
                    ((Printable)((Object)var)).print(p);
                } else {
                    p.print("(");
                    ((Printable)((Object)var)).print(p);
                    p.print(")");
                }
                if (!vit.hasNext()) continue;
                p.print(" ");
            }
        }
        this.printStringFrom(p);
        p.println();
        this.printWhere(p);
        this.printGroupBy(p);
        this.printHaving(p);
        this.printSolutionModifiers(p);
        this.printValues(p);
    }

    private void printGroupBy(PrintContext p) {
        RDFList list;
        ExtendedIterator<RDFNode> it;
        Statement groupByS = this.getProperty(SP.groupBy);
        if (groupByS != null && (it = (list = groupByS.getObject().as(RDFList.class)).iterator()).hasNext()) {
            p.println();
            p.printIndentation(p.getIndentation());
            p.printKeyword("GROUP BY");
            while (it.hasNext()) {
                p.print(" ");
                RDFNode node = (RDFNode)it.next();
                this.printNestedExpressionString(p, node);
            }
        }
    }

    private void printHaving(PrintContext p) {
        RDFList list;
        ExtendedIterator<RDFNode> it;
        Statement havingS = this.getProperty(SP.having);
        if (havingS != null && (it = (list = havingS.getObject().as(RDFList.class)).iterator()).hasNext()) {
            p.println();
            p.printIndentation(p.getIndentation());
            p.printKeyword("HAVING");
            while (it.hasNext()) {
                p.print(" ");
                RDFNode node = (RDFNode)it.next();
                this.printNestedExpressionString(p, node);
            }
        }
    }

    private void printVarExpr(PrintContext p, RDFNode varExpr) {
    }
}

