/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.spin.util.ClassPropertyMetadata;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaNodeUtil;
import org.topbraid.spin.util.OntologyOptimizations;

public class ClassMetadata {
    private Node classNode;
    private String graphKey;
    private Map<Node, Set<Node>> groupProperties;
    private Map<Node, ClassPropertyMetadata> properties = new HashMap<Node, ClassPropertyMetadata>();
    private List<ClassMetadata> superClasses;

    public static Object createKey(Node classNode, String graphKey) {
        return new Key(classNode, graphKey);
    }

    public ClassMetadata(Node classNode, String graphKey) {
        this.classNode = classNode;
        this.graphKey = graphKey;
    }

    public synchronized Set<Node> getGroupProperties(Node group, Graph graph) {
        if (this.groupProperties == null) {
            this.groupProperties = new HashMap<Node, Set<Node>>();
            if (JenaNodeUtil.isInstanceOf(this.classNode, SH.Shape.asNode(), graph)) {
                this.addGroupProperties(this.classNode, graph, SH.parameter.asNode());
                this.addGroupProperties(this.classNode, graph, SH.property.asNode());
            }
            ExtendedIterator<Triple> it = graph.find(null, SH.targetClass.asNode(), this.classNode);
            while (it.hasNext()) {
                Node shape = ((Triple)it.next()).getSubject();
                this.addGroupProperties(shape, graph, SH.parameter.asNode());
                this.addGroupProperties(shape, graph, SH.property.asNode());
            }
        }
        return this.groupProperties.get(group);
    }

    private void addGroupProperties(Node nodeShape, Graph graph, Node systemPredicate) {
        ExtendedIterator<Triple> it = graph.find(nodeShape, systemPredicate, Node.ANY);
        while (it.hasNext()) {
            Node path;
            Node group;
            Node propertyShape = ((Triple)it.next()).getObject();
            if (graph.contains(propertyShape, SH.deactivated.asNode(), JenaDatatypes.TRUE.asNode()) || (group = JenaNodeUtil.getObject(propertyShape, SH.group.asNode(), graph)) == null || (path = JenaNodeUtil.getObject(propertyShape, SH.path.asNode(), graph)) == null || !path.isURI()) continue;
            Set<Node> properties = this.groupProperties.get(group);
            if (properties == null) {
                properties = new HashSet<Node>();
                this.groupProperties.put(group, properties);
            }
            properties.add(path);
        }
    }

    public Node getPropertyDescription(final Node property, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, graph).getDescription();
            }
        }, null);
    }

    public Node getPropertyEditWidget(final Node property, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, graph).getEditWidget();
            }
        }, null);
    }

    public Node getPropertyLocalRange(final Node property, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, graph).getLocalRange();
            }
        }, null);
    }

    public Integer getPropertyMaxCount(final Node property, final Graph graph) {
        return (Integer)this.nearestObject(graph, new Function<ClassMetadata, Object>(){

            @Override
            public Object apply(ClassMetadata cm) {
                return cm.getProperty(property, graph).getMaxCount();
            }
        }, new HashSet<Node>());
    }

    public Node getPropertyName(final Node property, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, graph).getName();
            }
        }, null);
    }

    public Node getPropertyViewWidget(final Node property, final Graph graph) {
        return this.nearest(graph, new Function<ClassMetadata, Node>(){

            @Override
            public Node apply(ClassMetadata cm) {
                return cm.getProperty(property, graph).getViewWidget();
            }
        }, null);
    }

    public synchronized Iterable<ClassMetadata> getSuperClasses(Graph graph) {
        if (this.superClasses == null) {
            this.superClasses = new LinkedList<ClassMetadata>();
            ExtendedIterator<Triple> it = graph.find(this.classNode, RDFS.subClassOf.asNode(), Node.ANY);
            while (it.hasNext()) {
                Node superClass = ((Triple)it.next()).getObject();
                this.superClasses.add(OntologyOptimizations.get().getClassMetadata(superClass, graph, this.graphKey));
            }
        }
        return this.superClasses;
    }

    public synchronized ClassPropertyMetadata getProperty(Node propertyNode, Graph graph) {
        ClassPropertyMetadata result2 = this.properties.get(propertyNode);
        if (result2 == null) {
            result2 = new ClassPropertyMetadata(this.classNode, propertyNode, graph);
            this.properties.put(propertyNode, result2);
        }
        return result2;
    }

    private Node nearest(Graph graph, Function<ClassMetadata, Node> supplier, Set<Node> visited) {
        Node result2 = supplier.apply(this);
        if (result2 != null) {
            return result2;
        }
        if (visited == null) {
            visited = new HashSet<Node>();
        }
        visited.add(this.classNode);
        for (ClassMetadata superClass : this.getSuperClasses(graph)) {
            if (visited.contains(superClass.classNode) || (result2 = superClass.nearest(graph, supplier, visited)) == null) continue;
            return result2;
        }
        return null;
    }

    private Object nearestObject(Graph graph, Function<ClassMetadata, Object> supplier, Set<Node> visited) {
        if (!visited.contains(this.classNode)) {
            Object result2 = supplier.apply(this);
            if (result2 != null) {
                return result2;
            }
            visited.add(this.classNode);
            for (ClassMetadata superClass : this.getSuperClasses(graph)) {
                result2 = superClass.nearestObject(graph, supplier, visited);
                if (result2 == null) continue;
                return result2;
            }
        }
        return null;
    }

    public void walkSuperClasses(Graph graph, Consumer<ClassMetadata> consumer, Set<Node> visited) {
        if (!visited.contains(this.classNode)) {
            consumer.accept(this);
            visited.add(this.classNode);
            for (ClassMetadata superClassMetadata : this.getSuperClasses(graph)) {
                superClassMetadata.walkSuperClasses(graph, consumer, visited);
            }
        }
    }

    public boolean walkSuperClassesUntil(Graph graph, Predicate<ClassMetadata> predicate, Set<Node> visited) {
        if (!visited.contains(this.classNode)) {
            if (predicate.test(this)) {
                return true;
            }
            visited.add(this.classNode);
            for (ClassMetadata superClassMetadata : this.getSuperClasses(graph)) {
                if (!superClassMetadata.walkSuperClassesUntil(graph, predicate, visited)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return "ClassMetadata for " + this.classNode + " with " + this.properties.size() + " properties";
    }

    private static class Key {
        private Node classNode;
        private String graphKey;

        Key(Node classNode, String graphKey) {
            this.classNode = classNode;
            this.graphKey = graphKey;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Key) {
                return this.classNode.equals(((Key)obj).classNode) && this.graphKey.equals(((Key)obj).graphKey);
            }
            return false;
        }

        public int hashCode() {
            return this.classNode.hashCode() + this.graphKey.hashCode();
        }

        public String toString() {
            return this.graphKey + ".classMetadata." + this.classNode;
        }
    }
}

