/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.OWL;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.util.SHACLUtil;
import org.topbraid.shacl.vocabulary.SH;
import org.topbraid.shacl.vocabulary.TOSH;
import org.topbraid.spin.util.JenaDatatypes;
import org.topbraid.spin.util.JenaNodeUtil;
import org.topbraid.spin.util.LocalRangeAtClassNativeFunction;
import org.topbraid.spin.util.OptimizedMultiUnion;
import org.topbraid.spin.vocabulary.ARG;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class ClassPropertyMetadata {
    private Node description;
    private Node editWidget;
    private Node localRange;
    private Integer maxCount;
    private Node name;
    private Node order;
    private Node property;
    private Node viewWidget;

    ClassPropertyMetadata(Node classNode, Node property, Graph graph) {
        this.property = property;
        if (SHACLUtil.exists(graph)) {
            if (JenaNodeUtil.isInstanceOf(classNode, SH.Shape.asNode(), graph)) {
                this.initFromShape(classNode, graph);
            }
            ExtendedIterator<Triple> it = graph.find(null, SH.targetClass.asNode(), classNode);
            while (it.hasNext()) {
                Node shape = ((Triple)it.next()).getSubject();
                this.initFromShape(shape, graph);
            }
        }
        this.initFromOWLClass(classNode, graph);
        this.initFromSPINConstraints(classNode, graph);
    }

    public Node getDescription() {
        return this.description;
    }

    public Node getEditWidget() {
        return this.editWidget;
    }

    public Node getLocalRange() {
        return this.localRange;
    }

    public Integer getMaxCount() {
        return this.maxCount;
    }

    public Node getName() {
        return this.name;
    }

    public Node getOrder() {
        return this.order;
    }

    public Node getViewWidget() {
        return this.viewWidget;
    }

    private void initFromOWLClass(Node classNode, Graph graph) {
        ExtendedIterator<Triple> it = graph.find(classNode, RDFS.subClassOf.asNode(), Node.ANY);
        while (it.hasNext()) {
            Object value;
            Node superClass = ((Triple)it.next()).getObject();
            if (!superClass.isBlank() || !graph.contains(superClass, OWL.onProperty.asNode(), this.property)) continue;
            if (this.localRange == null) {
                this.localRange = JenaNodeUtil.getObject(superClass, OWL.allValuesFrom.asNode(), graph);
                if (this.localRange != null) {
                    it.close();
                    break;
                }
            }
            if (this.maxCount != null) continue;
            Node maxCountNode = JenaNodeUtil.getObject(superClass, OWL.maxCardinality.asNode(), graph);
            if (maxCountNode == null) {
                maxCountNode = JenaNodeUtil.getObject(superClass, OWL.cardinality.asNode(), graph);
            }
            if (maxCountNode == null || !maxCountNode.isLiteral() || !((value = maxCountNode.getLiteralValue()) instanceof Number)) continue;
            this.maxCount = ((Number)value).intValue();
        }
    }

    private void initFromShape(Node shape, Graph graph) {
        if (!graph.contains(shape, SH.deactivated.asNode(), JenaDatatypes.TRUE.asNode())) {
            this.initFromShape(shape, SH.property.asNode(), graph);
            this.initFromShape(shape, SH.parameter.asNode(), graph);
        }
    }

    private void initFromShape(Node shape, Node systemPredicate, Graph graph) {
        ExtendedIterator<Triple> it = graph.find(shape, systemPredicate, Node.ANY);
        while (it.hasNext()) {
            Object value;
            Node maxCountNode;
            Node propertyShape = ((Triple)it.next()).getObject();
            if (propertyShape.isLiteral() || !graph.contains(propertyShape, SH.path.asNode(), this.property) || graph.contains(propertyShape, SH.deactivated.asNode(), JenaDatatypes.TRUE.asNode())) continue;
            if (this.description == null) {
                this.description = JenaNodeUtil.getObject(propertyShape, SH.description.asNode(), graph);
            }
            if (this.editWidget == null) {
                this.editWidget = JenaNodeUtil.getObject(propertyShape, TOSH.editWidget.asNode(), graph);
            }
            if (this.localRange == null) {
                this.localRange = LocalRangeAtClassNativeFunction.walkPropertyShapesHelper(propertyShape, graph);
            }
            if (this.maxCount == null && (maxCountNode = JenaNodeUtil.getObject(propertyShape, SH.maxCount.asNode(), graph)) != null && maxCountNode.isLiteral() && (value = maxCountNode.getLiteralValue()) instanceof Number) {
                this.maxCount = ((Number)value).intValue();
            }
            if (this.name == null) {
                this.name = JenaNodeUtil.getObject(propertyShape, SH.name.asNode(), graph);
            }
            if (this.order == null) {
                this.order = JenaNodeUtil.getObject(propertyShape, SH.order.asNode(), graph);
            }
            if (this.viewWidget != null) continue;
            this.viewWidget = JenaNodeUtil.getObject(propertyShape, TOSH.viewWidget.asNode(), graph);
        }
    }

    private void initFromSPINConstraints(Node classNode, Graph graph) {
        if (!(graph instanceof OptimizedMultiUnion) || ((OptimizedMultiUnion)((Object)graph)).getIncludesSPIN()) {
            ExtendedIterator<Triple> it = graph.find(classNode, SPIN.constraint.asNode(), Node.ANY);
            while (it.hasNext()) {
                Node constraint = ((Triple)it.next()).getObject();
                if (graph.contains(constraint, SPL.predicate.asNode(), this.property) && (graph.contains(constraint, RDF.type.asNode(), SPL.Argument.asNode()) || graph.contains(constraint, RDF.type.asNode(), SPL.Attribute.asNode())) && this.localRange == null) {
                    this.localRange = JenaNodeUtil.getObject(constraint, SPL.valueType.asNode(), graph);
                }
                if (this.maxCount != null) continue;
                if (graph.contains(constraint, SPL.predicate.asNode(), this.property) && graph.contains(constraint, RDF.type.asNode(), SPL.Argument.asNode())) {
                    this.maxCount = 1;
                    continue;
                }
                if (!graph.contains(constraint, ARG.property.asNode(), this.property) || !graph.contains(constraint, RDF.type.asNode(), SPL.PrimaryKeyPropertyConstraint.asNode())) continue;
                this.maxCount = 1;
            }
        }
    }
}

