/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;

public class GraphBulkUpdate {
    public static void add(Graph graph, Triple[] triples) {
        GraphBulkUpdate.exec(graph, () -> {
            for (Triple triple : triples) {
                graph.add(triple);
            }
        });
    }

    public static void add(Graph graph, Iterator<Triple> triples) {
        LinkedList<Triple> list = new LinkedList<Triple>();
        while (triples.hasNext()) {
            list.add(triples.next());
        }
        GraphBulkUpdate.add(graph, list);
    }

    public static void add(Graph graph, List<Triple> triples) {
        GraphBulkUpdate.exec(graph, () -> {
            for (Triple triple : triples) {
                graph.add(triple);
            }
        });
    }

    public static void addInto(Graph graph, Graph src) {
        GraphBulkUpdate.add(graph, src.find(Triple.ANY));
    }

    public static void addInto(Model model, Model src) {
        GraphBulkUpdate.addInto(model.getGraph(), src.getGraph());
    }

    public static void delete(Graph graph, Triple[] triples) {
        GraphBulkUpdate.exec(graph, () -> {
            for (Triple triple : triples) {
                graph.delete(triple);
            }
        });
    }

    public static void delete(Graph graph, Iterator<Triple> triples) {
        LinkedList<Triple> list = new LinkedList<Triple>();
        while (triples.hasNext()) {
            list.add(triples.next());
        }
        GraphBulkUpdate.delete(graph, list);
    }

    public static void delete(Graph graph, List<Triple> triples) {
        GraphBulkUpdate.exec(graph, () -> {
            for (Triple triple : triples) {
                graph.delete(triple);
            }
        });
    }

    public static void deleteFrom(Graph graph, Graph src) {
        GraphBulkUpdate.delete(graph, src.find(Triple.ANY));
    }

    private static void exec(Graph graph, Runnable action) {
        action.run();
    }

    public static void execTransactional(Graph graph, Runnable action) {
        TransactionHandler handler = graph.getTransactionHandler();
        if (!handler.transactionsSupported()) {
            action.run();
            return;
        }
        try {
            handler.begin();
        }
        catch (Exception ex) {
            action.run();
            return;
        }
        try {
            action.run();
            handler.commit();
        }
        catch (Throwable e2) {
            try {
                handler.abort();
            }
            catch (Throwable e22) {
                e2.addSuppressed(e22);
            }
            throw e2;
        }
    }
}

