/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.XSD;
import org.topbraid.spin.vocabulary.RDFx;

public class JenaDatatypes {
    public static final Literal FALSE = ResourceFactory.createTypedLiteral("false", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.getURI()));
    public static final Literal TRUE = ResourceFactory.createTypedLiteral("true", TypeMapper.getInstance().getSafeTypeByName(XSD.xboolean.getURI()));
    private static Set<String> numericDatatypeURIs = new HashSet<String>();
    private static Set<String> otherDatatypeURIs = new HashSet<String>();

    public static Literal createDecimal(int value) {
        return ResourceFactory.createTypedLiteral("" + value, TypeMapper.getInstance().getSafeTypeByName(XSD.decimal.getURI()));
    }

    public static Literal createInteger(int value) {
        return ResourceFactory.createTypedLiteral("" + value, TypeMapper.getInstance().getSafeTypeByName(XSD.integer.getURI()));
    }

    public static List<String> getDatatypeURIs() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(otherDatatypeURIs);
        list.addAll(numericDatatypeURIs);
        list.add(RDFx.PlainLiteral.getURI());
        return list;
    }

    public static boolean isNumeric(String datatypeURI) {
        return numericDatatypeURIs.contains(datatypeURI);
    }

    public static boolean isSystemDatatype(RDFNode node) {
        if (node instanceof Resource && node.isURIResource()) {
            String uri = ((Resource)node).getURI();
            return JenaDatatypes.isNumeric(uri) || otherDatatypeURIs.contains(uri);
        }
        return false;
    }

    static {
        numericDatatypeURIs.add(XSD.decimal.getURI());
        numericDatatypeURIs.add(XSD.integer.getURI());
        numericDatatypeURIs.add(XSD.negativeInteger.getURI());
        numericDatatypeURIs.add(XSD.nonNegativeInteger.getURI());
        numericDatatypeURIs.add(XSD.nonPositiveInteger.getURI());
        numericDatatypeURIs.add(XSD.positiveInteger.getURI());
        numericDatatypeURIs.add(XSD.unsignedByte.getURI());
        numericDatatypeURIs.add(XSD.unsignedInt.getURI());
        numericDatatypeURIs.add(XSD.unsignedLong.getURI());
        numericDatatypeURIs.add(XSD.unsignedShort.getURI());
        numericDatatypeURIs.add(XSD.xbyte.getURI());
        numericDatatypeURIs.add(XSD.xdouble.getURI());
        numericDatatypeURIs.add(XSD.xfloat.getURI());
        numericDatatypeURIs.add(XSD.xint.getURI());
        numericDatatypeURIs.add(XSD.xlong.getURI());
        numericDatatypeURIs.add(XSD.xshort.getURI());
        otherDatatypeURIs.add(XSD.anyURI.getNameSpace() + "anySimpleType");
        otherDatatypeURIs.add(XSD.anyURI.getURI());
        otherDatatypeURIs.add(XSD.base64Binary.getURI());
        otherDatatypeURIs.add(XSD.date.getURI());
        otherDatatypeURIs.add(XSD.dateTime.getURI());
        otherDatatypeURIs.add(XSD.dateTimeStamp.getURI());
        otherDatatypeURIs.add(XSD.duration.getURI());
        otherDatatypeURIs.add(XSD.ENTITY.getURI());
        otherDatatypeURIs.add(XSD.gDay.getURI());
        otherDatatypeURIs.add(XSD.gMonth.getURI());
        otherDatatypeURIs.add(XSD.gMonthDay.getURI());
        otherDatatypeURIs.add(XSD.gYear.getURI());
        otherDatatypeURIs.add(XSD.gYearMonth.getURI());
        otherDatatypeURIs.add(XSD.hexBinary.getURI());
        otherDatatypeURIs.add(XSD.ID.getURI());
        otherDatatypeURIs.add(XSD.IDREF.getURI());
        otherDatatypeURIs.add(XSD.language.getURI());
        otherDatatypeURIs.add(XSD.Name.getURI());
        otherDatatypeURIs.add(XSD.NCName.getURI());
        otherDatatypeURIs.add(XSD.NMTOKEN.getURI());
        otherDatatypeURIs.add(XSD.normalizedString.getURI());
        otherDatatypeURIs.add(XSD.NOTATION.getURI());
        otherDatatypeURIs.add(XSD.QName.getURI());
        otherDatatypeURIs.add(XSD.time.getURI());
        otherDatatypeURIs.add(XSD.token.getURI());
        otherDatatypeURIs.add(XSD.xboolean.getURI());
        otherDatatypeURIs.add(XSD.xstring.getURI());
        otherDatatypeURIs.add(RDF.langString.getURI());
        otherDatatypeURIs.add(RDF.HTML.getURI());
        otherDatatypeURIs.add(RDF.xmlLiteral.getURI());
    }
}

