/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.util;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.topbraid.spin.constraints.ObjectPropertyPath;
import org.topbraid.spin.constraints.SimplePropertyPath;
import org.topbraid.spin.constraints.SubjectPropertyPath;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.visitor.AbstractTriplesVisitor;
import org.topbraid.spin.vocabulary.SPIN;

public class PropertyPathsGetter
extends AbstractTriplesVisitor {
    private Resource localThis;
    private Set<SimplePropertyPath> results = new HashSet<SimplePropertyPath>();
    private Model targetModel;

    public PropertyPathsGetter(Element element, Map<Property, RDFNode> initialBindings) {
        super(element, initialBindings);
        this.targetModel = element.getModel();
        this.localThis = SPIN._this.inModel(this.targetModel);
    }

    public Set<SimplePropertyPath> getResults() {
        return this.results;
    }

    @Override
    protected void handleTriplePattern(TriplePattern triplePattern, Map<Property, RDFNode> bindings) {
        Property pred;
        String uri;
        RDFNode b;
        Property argProperty;
        String varName;
        Property pred2;
        String uri2;
        Variable variable;
        Resource predicate;
        if (SPIN._this.equals(triplePattern.getSubject()) && (predicate = triplePattern.getPredicate()) != null && predicate.isURIResource()) {
            variable = SPINFactory.asVariable(predicate);
            if (variable == null) {
                uri2 = predicate.getURI();
                pred2 = this.targetModel.getProperty(uri2);
                this.results.add(new ObjectPropertyPath(this.localThis, pred2));
            } else if (bindings != null) {
                varName = variable.getName();
                argProperty = this.targetModel.getProperty("http://spinrdf.org/sp#" + varName);
                b = bindings.get(argProperty);
                if (b != null && b.isURIResource()) {
                    uri = ((Resource)b).getURI();
                    pred = this.targetModel.getProperty(uri);
                    this.results.add(new ObjectPropertyPath(this.localThis, pred));
                }
            }
        }
        if (SPIN._this.equals(triplePattern.getObject()) && (predicate = triplePattern.getPredicate()) != null && predicate.isURIResource()) {
            variable = SPINFactory.asVariable(predicate);
            if (variable == null) {
                uri2 = predicate.getURI();
                pred2 = this.targetModel.getProperty(uri2);
                this.results.add(new SubjectPropertyPath(this.localThis, pred2));
            } else if (bindings != null) {
                varName = variable.getName();
                argProperty = this.targetModel.getProperty("http://spinrdf.org/sp#" + varName);
                b = bindings.get(argProperty);
                if (b != null && b.isURIResource()) {
                    uri = ((Resource)b).getURI();
                    pred = this.targetModel.getProperty(uri);
                    this.results.add(new SubjectPropertyPath(this.localThis, pred));
                }
            }
        }
    }
}

