/*
 * Decompiled with CFR 0.152.
 */
package org.topbraid.spin.vocabulary;

import java.io.InputStream;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.enhanced.Personality;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.topbraid.shacl.model.SHFactory;
import org.topbraid.spin.model.Aggregation;
import org.topbraid.spin.model.Argument;
import org.topbraid.spin.model.Ask;
import org.topbraid.spin.model.Attribute;
import org.topbraid.spin.model.Bind;
import org.topbraid.spin.model.Construct;
import org.topbraid.spin.model.Describe;
import org.topbraid.spin.model.Element;
import org.topbraid.spin.model.ElementList;
import org.topbraid.spin.model.Exists;
import org.topbraid.spin.model.Filter;
import org.topbraid.spin.model.Function;
import org.topbraid.spin.model.FunctionCall;
import org.topbraid.spin.model.Minus;
import org.topbraid.spin.model.Module;
import org.topbraid.spin.model.NamedGraph;
import org.topbraid.spin.model.NotExists;
import org.topbraid.spin.model.Optional;
import org.topbraid.spin.model.SPINFactory;
import org.topbraid.spin.model.SPINInstance;
import org.topbraid.spin.model.Select;
import org.topbraid.spin.model.Service;
import org.topbraid.spin.model.SubQuery;
import org.topbraid.spin.model.Template;
import org.topbraid.spin.model.TemplateCall;
import org.topbraid.spin.model.TriplePath;
import org.topbraid.spin.model.TriplePattern;
import org.topbraid.spin.model.TripleTemplate;
import org.topbraid.spin.model.Union;
import org.topbraid.spin.model.Values;
import org.topbraid.spin.model.Variable;
import org.topbraid.spin.model.impl.AggregationImpl;
import org.topbraid.spin.model.impl.ArgumentImpl;
import org.topbraid.spin.model.impl.AskImpl;
import org.topbraid.spin.model.impl.AttributeImpl;
import org.topbraid.spin.model.impl.BindImpl;
import org.topbraid.spin.model.impl.ConstructImpl;
import org.topbraid.spin.model.impl.DescribeImpl;
import org.topbraid.spin.model.impl.ElementListImpl;
import org.topbraid.spin.model.impl.ExistsImpl;
import org.topbraid.spin.model.impl.FilterImpl;
import org.topbraid.spin.model.impl.FunctionCallImpl;
import org.topbraid.spin.model.impl.FunctionImpl;
import org.topbraid.spin.model.impl.MinusImpl;
import org.topbraid.spin.model.impl.ModuleImpl;
import org.topbraid.spin.model.impl.NamedGraphImpl;
import org.topbraid.spin.model.impl.NotExistsImpl;
import org.topbraid.spin.model.impl.OptionalImpl;
import org.topbraid.spin.model.impl.SPINInstanceImpl;
import org.topbraid.spin.model.impl.SelectImpl;
import org.topbraid.spin.model.impl.ServiceImpl;
import org.topbraid.spin.model.impl.SubQueryImpl;
import org.topbraid.spin.model.impl.TemplateCallImpl;
import org.topbraid.spin.model.impl.TemplateImpl;
import org.topbraid.spin.model.impl.TriplePathImpl;
import org.topbraid.spin.model.impl.TriplePatternImpl;
import org.topbraid.spin.model.impl.TripleTemplateImpl;
import org.topbraid.spin.model.impl.UnionImpl;
import org.topbraid.spin.model.impl.ValuesImpl;
import org.topbraid.spin.model.impl.VariableImpl;
import org.topbraid.spin.model.update.Clear;
import org.topbraid.spin.model.update.Create;
import org.topbraid.spin.model.update.Delete;
import org.topbraid.spin.model.update.DeleteData;
import org.topbraid.spin.model.update.DeleteWhere;
import org.topbraid.spin.model.update.Drop;
import org.topbraid.spin.model.update.Insert;
import org.topbraid.spin.model.update.InsertData;
import org.topbraid.spin.model.update.Load;
import org.topbraid.spin.model.update.Modify;
import org.topbraid.spin.model.update.impl.ClearImpl;
import org.topbraid.spin.model.update.impl.CreateImpl;
import org.topbraid.spin.model.update.impl.DeleteDataImpl;
import org.topbraid.spin.model.update.impl.DeleteImpl;
import org.topbraid.spin.model.update.impl.DeleteWhereImpl;
import org.topbraid.spin.model.update.impl.DropImpl;
import org.topbraid.spin.model.update.impl.InsertDataImpl;
import org.topbraid.spin.model.update.impl.InsertImpl;
import org.topbraid.spin.model.update.impl.LoadImpl;
import org.topbraid.spin.model.update.impl.ModifyImpl;
import org.topbraid.spin.util.SimpleImplementation;
import org.topbraid.spin.util.SimpleImplementation2;
import org.topbraid.spin.vocabulary.SPIN;
import org.topbraid.spin.vocabulary.SPL;

public class SP {
    public static final String BASE_URI = "http://spinrdf.org/sp";
    public static final String NS = "http://spinrdf.org/sp#";
    public static final String PREFIX = "sp";
    public static final String VAR_NS = "http://spinrdf.org/var#";
    public static final String VAR_PREFIX = "var";
    public static final Resource Aggregation = ResourceFactory.createResource("http://spinrdf.org/sp#Aggregation");
    public static final Resource AltPath = ResourceFactory.createResource("http://spinrdf.org/sp#AltPath");
    public static final Resource Asc = ResourceFactory.createResource("http://spinrdf.org/sp#Asc");
    public static final Resource Ask = ResourceFactory.createResource("http://spinrdf.org/sp#Ask");
    public static final Resource Avg = ResourceFactory.createResource("http://spinrdf.org/sp#Avg");
    public static final Resource Bind = ResourceFactory.createResource("http://spinrdf.org/sp#Bind");
    public static final Resource Clear = ResourceFactory.createResource("http://spinrdf.org/sp#Clear");
    public static final Resource Command = ResourceFactory.createResource("http://spinrdf.org/sp#Command");
    public static final Resource Construct = ResourceFactory.createResource("http://spinrdf.org/sp#Construct");
    public static final Resource Count = ResourceFactory.createResource("http://spinrdf.org/sp#Count");
    public static final Resource Create = ResourceFactory.createResource("http://spinrdf.org/sp#Create");
    @Deprecated
    public static final Resource Delete = ResourceFactory.createResource("http://spinrdf.org/sp#Delete");
    public static final Resource DeleteData = ResourceFactory.createResource("http://spinrdf.org/sp#DeleteData");
    public static final Resource DeleteWhere = ResourceFactory.createResource("http://spinrdf.org/sp#DeleteWhere");
    public static final Resource Desc = ResourceFactory.createResource("http://spinrdf.org/sp#Desc");
    public static final Resource Describe = ResourceFactory.createResource("http://spinrdf.org/sp#Describe");
    public static final Resource Drop = ResourceFactory.createResource("http://spinrdf.org/sp#Drop");
    public static final Resource exists = ResourceFactory.createResource("http://spinrdf.org/sp#exists");
    public static final Resource Exists = ResourceFactory.createResource("http://spinrdf.org/sp#Exists");
    public static final Resource Expression = ResourceFactory.createResource("http://spinrdf.org/sp#Expression");
    public static final Resource Filter = ResourceFactory.createResource("http://spinrdf.org/sp#Filter");
    @Deprecated
    public static final Resource Insert = ResourceFactory.createResource("http://spinrdf.org/sp#Insert");
    public static final Resource InsertData = ResourceFactory.createResource("http://spinrdf.org/sp#InsertData");
    @Deprecated
    public static final Resource Let = ResourceFactory.createResource("http://spinrdf.org/sp#Let");
    public static final Resource Load = ResourceFactory.createResource("http://spinrdf.org/sp#Load");
    public static final Resource Max = ResourceFactory.createResource("http://spinrdf.org/sp#Max");
    public static final Resource Min = ResourceFactory.createResource("http://spinrdf.org/sp#Min");
    public static final Resource Modify = ResourceFactory.createResource("http://spinrdf.org/sp#Modify");
    public static final Resource ModPath = ResourceFactory.createResource("http://spinrdf.org/sp#ModPath");
    public static final Resource Minus = ResourceFactory.createResource("http://spinrdf.org/sp#Minus");
    public static final Resource NamedGraph = ResourceFactory.createResource("http://spinrdf.org/sp#NamedGraph");
    public static final Resource notExists = ResourceFactory.createResource("http://spinrdf.org/sp#notExists");
    public static final Resource NotExists = ResourceFactory.createResource("http://spinrdf.org/sp#NotExists");
    public static final Resource Optional = ResourceFactory.createResource("http://spinrdf.org/sp#Optional");
    public static final Resource Query = ResourceFactory.createResource("http://spinrdf.org/sp#Query");
    public static final Resource ReverseLinkPath = ResourceFactory.createResource("http://spinrdf.org/sp#ReverseLinkPath");
    public static final Resource ReversePath = ResourceFactory.createResource("http://spinrdf.org/sp#ReversePath");
    public static final Resource Select = ResourceFactory.createResource("http://spinrdf.org/sp#Select");
    public static final Resource Service = ResourceFactory.createResource("http://spinrdf.org/sp#Service");
    public static final Resource SeqPath = ResourceFactory.createResource("http://spinrdf.org/sp#SeqPath");
    public static final Resource SubQuery = ResourceFactory.createResource("http://spinrdf.org/sp#SubQuery");
    public static final Resource Sum = ResourceFactory.createResource("http://spinrdf.org/sp#Sum");
    public static final Resource Triple = ResourceFactory.createResource("http://spinrdf.org/sp#Triple");
    public static final Resource TriplePath = ResourceFactory.createResource("http://spinrdf.org/sp#TriplePath");
    public static final Resource TriplePattern = ResourceFactory.createResource("http://spinrdf.org/sp#TriplePattern");
    public static final Resource TripleTemplate = ResourceFactory.createResource("http://spinrdf.org/sp#TripleTemplate");
    public static final Resource undef = ResourceFactory.createResource("http://spinrdf.org/sp#undef");
    public static final Resource Union = ResourceFactory.createResource("http://spinrdf.org/sp#Union");
    public static final Resource Update = ResourceFactory.createResource("http://spinrdf.org/sp#Update");
    public static final Resource Values = ResourceFactory.createResource("http://spinrdf.org/sp#Values");
    public static final Resource Variable = ResourceFactory.createResource("http://spinrdf.org/sp#Variable");
    public static final Property all = ResourceFactory.createProperty("http://spinrdf.org/sp#all");
    public static final Property arg = ResourceFactory.createProperty("http://spinrdf.org/sp#arg");
    public static final Property arg1 = ResourceFactory.createProperty("http://spinrdf.org/sp#arg1");
    public static final Property arg2 = ResourceFactory.createProperty("http://spinrdf.org/sp#arg2");
    public static final Property arg3 = ResourceFactory.createProperty("http://spinrdf.org/sp#arg3");
    public static final Property arg4 = ResourceFactory.createProperty("http://spinrdf.org/sp#arg4");
    public static final Property arg5 = ResourceFactory.createProperty("http://spinrdf.org/sp#arg5");
    public static final Property as = ResourceFactory.createProperty("http://spinrdf.org/sp#as");
    public static final Property bindings = ResourceFactory.createProperty("http://spinrdf.org/sp#bindings");
    public static final Property data = ResourceFactory.createProperty("http://spinrdf.org/sp#data");
    public static final Property default_ = ResourceFactory.createProperty("http://spinrdf.org/sp#default");
    public static final Property deletePattern = ResourceFactory.createProperty("http://spinrdf.org/sp#deletePattern");
    public static final Property distinct = ResourceFactory.createProperty("http://spinrdf.org/sp#distinct");
    public static final Property document = ResourceFactory.createProperty("http://spinrdf.org/sp#document");
    public static final Property elements = ResourceFactory.createProperty("http://spinrdf.org/sp#elements");
    public static final Property expression = ResourceFactory.createProperty("http://spinrdf.org/sp#expression");
    public static final Property from = ResourceFactory.createProperty("http://spinrdf.org/sp#from");
    public static final Property fromNamed = ResourceFactory.createProperty("http://spinrdf.org/sp#fromNamed");
    public static final Property graphIRI = ResourceFactory.createProperty("http://spinrdf.org/sp#graphIRI");
    public static final Property graphNameNode = ResourceFactory.createProperty("http://spinrdf.org/sp#graphNameNode");
    public static final Property groupBy = ResourceFactory.createProperty("http://spinrdf.org/sp#groupBy");
    public static final Property having = ResourceFactory.createProperty("http://spinrdf.org/sp#having");
    public static final Property insertPattern = ResourceFactory.createProperty("http://spinrdf.org/sp#insertPattern");
    public static final Property into = ResourceFactory.createProperty("http://spinrdf.org/sp#into");
    public static final Property limit = ResourceFactory.createProperty("http://spinrdf.org/sp#limit");
    public static final Property modMax = ResourceFactory.createProperty("http://spinrdf.org/sp#modMax");
    public static final Property modMin = ResourceFactory.createProperty("http://spinrdf.org/sp#modMin");
    public static final Property named = ResourceFactory.createProperty("http://spinrdf.org/sp#named");
    public static final Property node = ResourceFactory.createProperty("http://spinrdf.org/sp#node");
    public static final Property object = ResourceFactory.createProperty("http://spinrdf.org/sp#object");
    public static final Property offset = ResourceFactory.createProperty("http://spinrdf.org/sp#offset");
    public static final Property orderBy = ResourceFactory.createProperty("http://spinrdf.org/sp#orderBy");
    public static final Property path = ResourceFactory.createProperty("http://spinrdf.org/sp#path");
    public static final Property path1 = ResourceFactory.createProperty("http://spinrdf.org/sp#path1");
    public static final Property path2 = ResourceFactory.createProperty("http://spinrdf.org/sp#path2");
    public static final Property predicate = ResourceFactory.createProperty("http://spinrdf.org/sp#predicate");
    public static final Property query = ResourceFactory.createProperty("http://spinrdf.org/sp#query");
    public static final Property reduced = ResourceFactory.createProperty("http://spinrdf.org/sp#reduced");
    public static final Property resultNodes = ResourceFactory.createProperty("http://spinrdf.org/sp#resultNodes");
    public static final Property resultVariables = ResourceFactory.createProperty("http://spinrdf.org/sp#resultVariables");
    public static final Property separator = ResourceFactory.createProperty("http://spinrdf.org/sp#separator");
    public static final Property serviceURI = ResourceFactory.createProperty("http://spinrdf.org/sp#serviceURI");
    public static final Property silent = ResourceFactory.createProperty("http://spinrdf.org/sp#silent");
    public static final Property str = ResourceFactory.createProperty("http://spinrdf.org/sp#str");
    public static final Property strlang = ResourceFactory.createProperty("http://spinrdf.org/sp#strlang");
    public static final Property subject = ResourceFactory.createProperty("http://spinrdf.org/sp#subject");
    public static final Property subPath = ResourceFactory.createProperty("http://spinrdf.org/sp#subPath");
    public static final Property templates = ResourceFactory.createProperty("http://spinrdf.org/sp#templates");
    public static final Property text = ResourceFactory.createProperty("http://spinrdf.org/sp#text");
    public static final Property using = ResourceFactory.createProperty("http://spinrdf.org/sp#using");
    public static final Property usingNamed = ResourceFactory.createProperty("http://spinrdf.org/sp#usingNamed");
    public static final Property values = ResourceFactory.createProperty("http://spinrdf.org/sp#values");
    public static final Property variable = ResourceFactory.createProperty("http://spinrdf.org/sp#variable");
    public static final Property varName = ResourceFactory.createProperty("http://spinrdf.org/sp#varName");
    public static final Property varNames = ResourceFactory.createProperty("http://spinrdf.org/sp#varNames");
    public static final Property where = ResourceFactory.createProperty("http://spinrdf.org/sp#where");
    public static final Property with = ResourceFactory.createProperty("http://spinrdf.org/sp#with");
    public static final Resource bound = ResourceFactory.createResource("http://spinrdf.org/sp#bound");
    public static final Resource eq = ResourceFactory.createResource("http://spinrdf.org/sp#eq");
    public static final Resource not = ResourceFactory.createResource("http://spinrdf.org/sp#not");
    public static final Resource regex = ResourceFactory.createResource("http://spinrdf.org/sp#regex");
    public static final Resource sub = ResourceFactory.createResource("http://spinrdf.org/sp#sub");
    public static final Resource unaryMinus = ResourceFactory.createResource("http://spinrdf.org/sp#unaryMinus");
    private static Model model;

    public static synchronized Model getModel() {
        if (model == null) {
            model = ModelFactory.createDefaultModel();
            InputStream is = SP.class.getResourceAsStream("/etc/sp.ttl");
            if (is == null) {
                model.read(BASE_URI);
            } else {
                model.read(is, "http://dummy", "TURTLE");
            }
        }
        return model;
    }

    private static void init(Personality<RDFNode> p) {
        p.add(Aggregation.class, new SimpleImplementation(SPL.Argument.asNode(), AggregationImpl.class));
        p.add(Argument.class, new SimpleImplementation(SPL.Argument.asNode(), ArgumentImpl.class));
        p.add(Attribute.class, new SimpleImplementation(SPL.Attribute.asNode(), AttributeImpl.class));
        p.add(Ask.class, new SimpleImplementation(Ask.asNode(), AskImpl.class));
        p.add(Bind.class, new SimpleImplementation2(Bind.asNode(), Let.asNode(), BindImpl.class));
        p.add(Clear.class, new SimpleImplementation(Clear.asNode(), ClearImpl.class));
        p.add(Construct.class, new SimpleImplementation(Construct.asNode(), ConstructImpl.class));
        p.add(Create.class, new SimpleImplementation(Create.asNode(), CreateImpl.class));
        p.add(Delete.class, new SimpleImplementation(Delete.asNode(), DeleteImpl.class));
        p.add(DeleteData.class, new SimpleImplementation(DeleteData.asNode(), DeleteDataImpl.class));
        p.add(DeleteWhere.class, new SimpleImplementation(DeleteWhere.asNode(), DeleteWhereImpl.class));
        p.add(Describe.class, new SimpleImplementation(Describe.asNode(), DescribeImpl.class));
        p.add(Drop.class, new SimpleImplementation(Drop.asNode(), DropImpl.class));
        p.add(ElementList.class, new SimpleImplementation(RDF.List.asNode(), ElementListImpl.class));
        p.add(Exists.class, new SimpleImplementation(Exists.asNode(), ExistsImpl.class));
        p.add(Function.class, new SimpleImplementation(SPIN.Function.asNode(), FunctionImpl.class));
        p.add(FunctionCall.class, new SimpleImplementation(SPIN.Function.asNode(), FunctionCallImpl.class));
        p.add(Filter.class, new SimpleImplementation(Filter.asNode(), FilterImpl.class));
        p.add(Insert.class, new SimpleImplementation(Insert.asNode(), InsertImpl.class));
        p.add(InsertData.class, new SimpleImplementation(InsertData.asNode(), InsertDataImpl.class));
        p.add(Load.class, new SimpleImplementation(Load.asNode(), LoadImpl.class));
        p.add(Minus.class, new SimpleImplementation(Minus.asNode(), MinusImpl.class));
        p.add(Modify.class, new SimpleImplementation(Modify.asNode(), ModifyImpl.class));
        p.add(Module.class, new SimpleImplementation(SPIN.Module.asNode(), ModuleImpl.class));
        p.add(NamedGraph.class, new SimpleImplementation(NamedGraph.asNode(), NamedGraphImpl.class));
        p.add(NotExists.class, new SimpleImplementation(NotExists.asNode(), NotExistsImpl.class));
        p.add(Optional.class, new SimpleImplementation(Optional.asNode(), OptionalImpl.class));
        p.add(Service.class, new SimpleImplementation(Service.asNode(), ServiceImpl.class));
        p.add(Select.class, new SimpleImplementation(Select.asNode(), SelectImpl.class));
        p.add(SubQuery.class, new SimpleImplementation(SubQuery.asNode(), SubQueryImpl.class));
        p.add(SPINInstance.class, new SimpleImplementation(RDFS.Resource.asNode(), SPINInstanceImpl.class));
        p.add(Template.class, new SimpleImplementation(SPIN.Template.asNode(), TemplateImpl.class));
        p.add(TemplateCall.class, new SimpleImplementation(RDFS.Resource.asNode(), TemplateCallImpl.class));
        p.add(TriplePath.class, new SimpleImplementation(TriplePath.asNode(), TriplePathImpl.class));
        p.add(TriplePattern.class, new SimpleImplementation(TriplePattern.asNode(), TriplePatternImpl.class));
        p.add(TripleTemplate.class, new SimpleImplementation(TripleTemplate.asNode(), TripleTemplateImpl.class));
        p.add(Union.class, new SimpleImplementation(Union.asNode(), UnionImpl.class));
        p.add(Values.class, new SimpleImplementation(Values.asNode(), ValuesImpl.class));
        p.add(Variable.class, new SimpleImplementation(Variable.asNode(), VariableImpl.class));
        new SHFactory();
    }

    public static boolean exists(Model model) {
        return model != null && NS.equals(model.getNsPrefixURI(PREFIX)) && model.contains(Query, RDF.type, (RDFNode)null);
    }

    public static Property getArgProperty(int index) {
        return ResourceFactory.createProperty("http://spinrdf.org/sp#arg" + index);
    }

    public static Property getArgProperty(String varName) {
        return ResourceFactory.createProperty(NS + varName);
    }

    public static Integer getArgPropertyIndex(String varName) {
        if (varName.startsWith("arg")) {
            String subString = varName.substring(3);
            try {
                return Integer.getInteger(subString);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static String getURI() {
        return NS;
    }

    public static void toStringElementList(StringBuffer buffer, Resource resource) {
        RDFList list = resource.as(RDFList.class);
        ExtendedIterator<RDFNode> it = list.iterator();
        while (it.hasNext()) {
            Resource item = (Resource)it.next();
            Element e2 = SPINFactory.asElement(item);
            buffer.append(e2.toString());
            if (!it.hasNext()) continue;
            buffer.append(" .\n");
        }
    }

    static {
        SP.init(BuiltinPersonalities.model);
    }
}

