/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xpath;

import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.impl.xpath.DataMatcher;
import org.mule.apache.xerces.impl.xpath.XPathException;
import org.mule.apache.xerces.impl.xpath.XPathSyntaxTreeNode;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xni.XMLAttributes;

class CompNode
extends XPathSyntaxTreeNode {
    private int comp;
    private XPathSyntaxTreeNode child1;
    private XPathSyntaxTreeNode child2;
    public static final int EQ = 0;
    public static final int NE = 1;
    public static final int LT = 2;
    public static final int GT = 3;
    public static final int LE = 4;
    public static final int GE = 5;

    public CompNode(int comp, XPathSyntaxTreeNode child1, XPathSyntaxTreeNode child2) {
        this.comp = comp;
        this.child1 = child1;
        this.child2 = child2;
    }

    @Override
    public boolean evaluate(QName element, XMLAttributes attributes, NamespaceContext nsContext) throws Exception {
        int type1 = this.child1.getType();
        int type2 = this.child2.getType();
        if (type1 == 2 && type2 == 0) {
            String attrValue = this.child1.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("double");
            Object obj1 = simpleType.validate(attrValue, null, null);
            Object obj2 = this.child2.getValue(attributes, nsContext);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 2 && type2 == 1) {
            String attrValue = this.child1.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("string");
            Object obj1 = simpleType.validate(attrValue, null, null);
            Object obj2 = this.child2.getValue(attributes, nsContext);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 0 && type2 == 2) {
            String attrValue = this.child2.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("double");
            Object obj1 = this.child1.getValue(attributes, nsContext);
            Object obj2 = simpleType.validate(attrValue, null, null);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 1 && type2 == 2) {
            String attrValue = this.child2.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("string");
            Object obj1 = this.child1.getValue(attributes, nsContext);
            Object obj2 = simpleType.validate(attrValue, null, null);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 2 && type2 == 2) {
            String attrVal1 = this.child1.getValue(attributes, nsContext).toString();
            String attrVal2 = this.child2.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("string");
            Object obj1 = simpleType.validate(attrVal1, null, null);
            Object obj2 = simpleType.validate(attrVal2, null, null);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 2 && type2 == 3) {
            String attrVal = this.child1.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)this.child2.getSimpleType();
            if (simpleType == null) {
                throw new XPathException("Casted type is not a built-in type");
            }
            Object obj1 = simpleType.validate(attrVal, null, null);
            Object obj2 = this.child2.getValue(attributes, nsContext);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 3 && type2 == 2) {
            String attrVal = this.child2.getValue(attributes, nsContext).toString();
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)this.child1.getSimpleType();
            if (simpleType == null) {
                throw new XPathException("Casted type is not a built-in type");
            }
            Object obj1 = this.child1.getValue(attributes, nsContext);
            Object obj2 = simpleType.validate(attrVal, null, null);
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 3 && type2 == 3) {
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)this.child1.getSimpleType();
            if (simpleType == null) {
                throw new XPathException("Casted type is not a built-in type");
            }
            short dt1 = simpleType.getBuiltInKind();
            simpleType = (XSSimpleTypeDecl)this.child2.getSimpleType();
            if (simpleType == null) {
                throw new XPathException("Casted type is not a built-in type");
            }
            short dt2 = simpleType.getBuiltInKind();
            if (DataMatcher.isComparable(dt1, dt2, null, null)) {
                Object obj1 = simpleType.validate(this.child1.getValue(attributes, nsContext), null, null);
                Object obj2 = this.child2.getValue(attributes, nsContext);
                return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
            }
            throw new XPathException("Invalid comparison between incompatible types");
        }
        if (type1 == 0 && type2 == 0) {
            Object obj1 = this.child1.getValue(attributes, nsContext);
            Object obj2 = this.child2.getValue(attributes, nsContext);
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("double");
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        if (type1 == 1 && type2 == 1) {
            Object obj1 = this.child1.getValue(attributes, nsContext);
            Object obj2 = this.child2.getValue(attributes, nsContext);
            XSSimpleTypeDecl simpleType = (XSSimpleTypeDecl)dvFactory.getBuiltInType("string");
            return DataMatcher.compareActualValues(obj1, obj2, this.comp, simpleType);
        }
        throw new XPathException("Invalid comparison");
    }
}

