/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs;

import java.util.Vector;
import org.mule.apache.xerces.impl.xs.XMLSchemaValidator;
import org.mule.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.mule.apache.xerces.impl.xs.XSElementDecl;
import org.mule.apache.xerces.impl.xs.alternative.Test;
import org.mule.apache.xerces.impl.xs.alternative.XSTypeAlternativeImpl;
import org.mule.apache.xerces.impl.xs.util.ObjectListImpl;
import org.mule.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.util.XMLAttributesImpl;
import org.mule.apache.xerces.xni.Augmentations;
import org.mule.apache.xerces.xni.NamespaceContext;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xni.XMLAttributes;
import org.mule.apache.xerces.xs.AttributePSVI;
import org.mule.apache.xerces.xs.XSAttributeDeclaration;
import org.mule.apache.xerces.xs.XSAttributeUse;
import org.mule.apache.xerces.xs.XSTypeAlternative;
import org.mule.apache.xerces.xs.datatypes.ObjectList;

public class XSDTypeAlternativeValidator {
    XMLSchemaValidator fXmlSchemaValidator = null;

    public XSDTypeAlternativeValidator(XMLSchemaValidator xmlSchemaValidator) {
        this.fXmlSchemaValidator = xmlSchemaValidator;
    }

    public XSTypeAlternative getTypeAlternative(XSElementDecl currentElemDecl, QName element, XMLAttributes attributes, Vector inheritableAttrList, NamespaceContext instanceNamespaceContext, String expandedSystemId) {
        XSTypeAlternativeImpl selectedTypeAlternative = null;
        XSTypeAlternativeImpl[] typeAlternatives = currentElemDecl.getTypeAlternatives();
        if (typeAlternatives != null) {
            XMLAttributes ctaAttributes = this.getAttributesForCTA(attributes, inheritableAttrList);
            for (int typeAltIdx = 0; typeAltIdx < typeAlternatives.length; ++typeAltIdx) {
                Test ctaTest = typeAlternatives[typeAltIdx].getTest();
                if (ctaTest == null || !ctaTest.evaluateTest(element, ctaAttributes, instanceNamespaceContext, expandedSystemId)) continue;
                selectedTypeAlternative = typeAlternatives[typeAltIdx];
                break;
            }
            if (selectedTypeAlternative == null) {
                selectedTypeAlternative = currentElemDecl.getDefaultTypeDefinition();
            }
        }
        return selectedTypeAlternative;
    }

    private XMLAttributes getAttributesForCTA(XMLAttributes attributes, Vector inheritableAttrList) {
        XMLAttributesImpl ctaAttributes = new XMLAttributesImpl();
        for (int attrIndx = 0; attrIndx < attributes.getLength(); ++attrIndx) {
            QName attrQName = new QName();
            attributes.getName(attrIndx, attrQName);
            ctaAttributes.addAttribute(attrQName, attributes.getType(attrIndx), attributes.getValue(attrIndx));
        }
        for (int elemIndx = inheritableAttrList.size() - 1; elemIndx > -1; --elemIndx) {
            AttributePSVI inhAttrPsvi = (AttributePSVI)inheritableAttrList.elementAt(elemIndx);
            XSAttributeDeclaration inhrAttrDecl = inhAttrPsvi.getAttributeDeclaration();
            if (this.isInheritedAttributeOverridden(ctaAttributes, inhrAttrDecl)) continue;
            QName attrQName = new QName();
            attrQName.setValues(null, inhrAttrDecl.getName(), inhrAttrDecl.getName(), inhrAttrDecl.getNamespace());
            ctaAttributes.addAttribute(attrQName, null, inhAttrPsvi.getSchemaValue().getNormalizedValue());
        }
        return ctaAttributes;
    }

    private boolean isInheritedAttributeOverridden(XMLAttributes attributes, XSAttributeDeclaration inhrAttrDecl) {
        boolean attrExists = false;
        for (int attrIndx = 0; attrIndx < attributes.getLength(); ++attrIndx) {
            if (!attributes.getLocalName(attrIndx).equals(inhrAttrDecl.getName()) || !XS11TypeHelper.isURIEqual(attributes.getURI(attrIndx), inhrAttrDecl.getNamespace())) continue;
            attrExists = true;
            break;
        }
        return attrExists;
    }

    void saveInheritableAttributes(XSElementDecl currentElemDecl, XMLAttributes attributes) {
        if (currentElemDecl != null && currentElemDecl.fType instanceof XSComplexTypeDecl) {
            XSComplexTypeDecl complexTypeDecl = (XSComplexTypeDecl)currentElemDecl.fType;
            XSObjectListImpl attributeUses = (XSObjectListImpl)complexTypeDecl.getAttributeUses();
            for (int attrUsesIndx = 0; attrUsesIndx < attributeUses.getLength(); ++attrUsesIndx) {
                XSAttributeDeclaration attrDecl;
                Augmentations attrAugs;
                XSAttributeUse attrUse = (XSAttributeUse)attributeUses.get(attrUsesIndx);
                if (!attrUse.getInheritable() || (attrAugs = attributes.getAugmentations((attrDecl = attrUse.getAttrDeclaration()).getNamespace(), attrDecl.getName())) == null) continue;
                this.fXmlSchemaValidator.getInheritableAttrList().add((AttributePSVI)attrAugs.getItem("ATTRIBUTE_PSVI"));
            }
        }
    }

    ObjectList getInheritedAttributesForPSVI() {
        ObjectListImpl inheritedAttributesList = null;
        Vector inheritableAttrList = this.fXmlSchemaValidator.getInheritableAttrList();
        if (inheritableAttrList.size() > 0) {
            Object[] inheritedAttributesArray = new Object[inheritableAttrList.size()];
            for (int inhrAttrIdx = 0; inhrAttrIdx < inheritableAttrList.size(); ++inhrAttrIdx) {
                inheritedAttributesArray[inhrAttrIdx] = inheritableAttrList.get(inhrAttrIdx);
            }
            inheritedAttributesList = new ObjectListImpl(inheritedAttributesArray, inheritedAttributesArray.length);
        }
        return inheritedAttributesList;
    }
}

