/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.traversers;

import java.util.Vector;
import org.mule.apache.xerces.impl.Constants;
import org.mule.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.mule.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.mule.apache.xerces.impl.dv.XSFacets;
import org.mule.apache.xerces.impl.dv.XSSimpleType;
import org.mule.apache.xerces.impl.dv.xs.AnyURIDV;
import org.mule.apache.xerces.impl.dv.xs.TypeValidator;
import org.mule.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.mule.apache.xerces.impl.xs.SchemaGrammar;
import org.mule.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.mule.apache.xerces.impl.xs.SchemaSymbols;
import org.mule.apache.xerces.impl.xs.XSAnnotationImpl;
import org.mule.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.mule.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.mule.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.mule.apache.xerces.impl.xs.XSConstraints;
import org.mule.apache.xerces.impl.xs.XSModelGroupImpl;
import org.mule.apache.xerces.impl.xs.XSOpenContentDecl;
import org.mule.apache.xerces.impl.xs.XSParticleDecl;
import org.mule.apache.xerces.impl.xs.XSWildcardDecl;
import org.mule.apache.xerces.impl.xs.assertion.Test;
import org.mule.apache.xerces.impl.xs.assertion.XSAssertImpl;
import org.mule.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.mule.apache.xerces.impl.xs.traversers.XSDAbstractParticleTraverser;
import org.mule.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.mule.apache.xerces.impl.xs.traversers.XSDHandler;
import org.mule.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.mule.apache.xerces.impl.xs.util.XInt;
import org.mule.apache.xerces.impl.xs.util.XS11TypeHelper;
import org.mule.apache.xerces.impl.xs.util.XSObjectListImpl;
import org.mule.apache.xerces.util.DOMUtil;
import org.mule.apache.xerces.util.XMLChar;
import org.mule.apache.xerces.util.XMLSymbols;
import org.mule.apache.xerces.xni.QName;
import org.mule.apache.xerces.xs.XSAttributeUse;
import org.mule.apache.xerces.xs.XSComplexTypeDefinition;
import org.mule.apache.xerces.xs.XSMultiValueFacet;
import org.mule.apache.xerces.xs.XSObject;
import org.mule.apache.xerces.xs.XSObjectList;
import org.mule.apache.xerces.xs.XSSimpleTypeDefinition;
import org.mule.apache.xerces.xs.XSTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class XSDComplexTypeTraverser
extends XSDAbstractParticleTraverser {
    private static final int GLOBAL_NUM = 13;
    private static XSParticleDecl fErrorContent = null;
    private static XSWildcardDecl fErrorWildcard = null;
    private String fName = null;
    private String fTargetNamespace = null;
    private short fDerivedBy = (short)2;
    private short fFinal = 0;
    private short fBlock = 0;
    private short fContentType = 0;
    private XSTypeDefinition fBaseType = null;
    private XSAttributeGroupDecl fAttrGrp = null;
    private XSSimpleType fXSSimpleType = null;
    private XSParticleDecl fParticle = null;
    private boolean fIsAbstract = false;
    private XSComplexTypeDecl fComplexTypeDecl = null;
    private XSAnnotationImpl[] fAnnotations = null;
    private XSOpenContentDecl fOpenContent = null;
    private XSAssertImpl[] fAssertions = null;
    private Object[] fGlobalStore = null;
    private int fGlobalStorePos = 0;
    private static final boolean DEBUG = false;

    private static XSParticleDecl getErrorContent() {
        if (fErrorContent == null) {
            XSParticleDecl particle = new XSParticleDecl();
            particle.fType = (short)2;
            particle.fValue = XSDComplexTypeTraverser.getErrorWildcard();
            particle.fMinOccurs = 0;
            particle.fMaxOccurs = -1;
            XSModelGroupImpl group = new XSModelGroupImpl();
            group.fCompositor = (short)102;
            group.fParticleCount = 1;
            group.fParticles = new XSParticleDecl[1];
            group.fParticles[0] = particle;
            XSParticleDecl errorContent = new XSParticleDecl();
            errorContent.fType = (short)3;
            errorContent.fValue = group;
            fErrorContent = errorContent;
        }
        return fErrorContent;
    }

    private static XSWildcardDecl getErrorWildcard() {
        if (fErrorWildcard == null) {
            XSWildcardDecl wildcard = new XSWildcardDecl();
            wildcard.fProcessContents = (short)2;
            fErrorWildcard = wildcard;
        }
        return fErrorWildcard;
    }

    XSDComplexTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSComplexTypeDecl traverseLocal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar, XSObject context) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, false, schemaDoc);
        String complexTypeName = this.genAnonTypeName(complexTypeNode);
        this.contentBackup();
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar, context);
        this.contentRestore();
        grammar.addComplexTypeDecl(type, this.fSchemaHandler.element2Locator(complexTypeNode));
        type.setIsAnonymous();
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    XSComplexTypeDecl traverseGlobal(Element complexTypeNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(complexTypeNode, true, schemaDoc);
        String complexTypeName = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        this.contentBackup();
        XSComplexTypeDecl type = this.traverseComplexTypeDecl(complexTypeNode, complexTypeName, attrValues, schemaDoc, grammar, null);
        this.contentRestore();
        grammar.addComplexTypeDecl(type, this.fSchemaHandler.element2Locator(complexTypeNode));
        if (complexTypeName == null) {
            this.reportSchemaError("s4s-att-must-appear", new Object[]{SchemaSymbols.ELT_COMPLEXTYPE, SchemaSymbols.ATT_NAME}, complexTypeNode);
            type = null;
        } else {
            if (DOMUtil.getLocalName(DOMUtil.getParent(complexTypeNode)).equals(SchemaSymbols.ELT_REDEFINE)) {
                if (this.fSchemaHandler.fSchemaVersion == 4) {
                    ((XSComplexTypeDecl)type.getBaseType()).setContext(type);
                }
                grammar.addGlobalComplexTypeDecl(type);
            }
            if (grammar.getGlobalTypeDecl(type.getName()) == null) {
                grammar.addGlobalComplexTypeDecl(type);
            }
            String loc = this.fSchemaHandler.schemaDocument2SystemId(schemaDoc);
            XSTypeDefinition type2 = grammar.getGlobalTypeDecl(type.getName(), loc);
            if (type2 == null) {
                grammar.addGlobalComplexTypeDecl(type, loc);
            }
            if (this.fSchemaHandler.fTolerateDuplicates) {
                if (type2 != null && type2 instanceof XSComplexTypeDecl) {
                    type = (XSComplexTypeDecl)type2;
                }
                this.fSchemaHandler.addGlobalTypeDecl(type);
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    XSOpenContentDecl traverseOpenContent(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar, boolean isDefault) {
        String text;
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, isDefault, schemaDoc);
        XSOpenContentDecl ocDecl = new XSOpenContentDecl();
        XInt modeAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_MODE];
        short ocMode = modeAttr.shortValue();
        if (isDefault) {
            Boolean appliesToEmptyAttr = (Boolean)attrValues[XSAttributeChecker.ATTIDX_APPLIESTOEMPTY];
            ocDecl.fAppliesToEmpty = appliesToEmptyAttr;
        }
        ocDecl.fMode = ocMode;
        Element child = DOMUtil.getFirstChildElement(elmNode);
        if (child != null) {
            if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.addAnnotation(this.traverseAnnotationDecl(child, attrValues, false, schemaDoc));
                child = DOMUtil.getNextSiblingElement(child);
            } else {
                text = DOMUtil.getSyntheticAnnotation(elmNode);
                if (text != null) {
                    this.addAnnotation(this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc));
                }
            }
            if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.reportSchemaError("s4s-elt-invalid-content.1", new Object[]{SchemaSymbols.ELT_OPENCONTENT, SchemaSymbols.ELT_ANNOTATION}, child);
            }
        } else {
            text = DOMUtil.getSyntheticAnnotation(elmNode);
            if (text != null) {
                this.addAnnotation(this.traverseSyntheticAnnotation(elmNode, text, attrValues, false, schemaDoc));
            }
        }
        if (child == null) {
            if (ocMode != 0) {
                this.reportSchemaError("src-ct.6", new Object[]{this.fName}, elmNode);
            }
        } else {
            String childName = DOMUtil.getLocalName(child);
            if (!childName.equals(SchemaSymbols.ELT_ANY) || DOMUtil.getNextSiblingElement(child) != null) {
                this.reportSchemaError("s4s-elt-must-match.1", new Object[]{SchemaSymbols.ELT_OPENCONTENT, "(annotation?, any?)", childName}, child);
                this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
                return ocDecl;
            }
            Attr anyWcMinOccurs = DOMUtil.getAttr(child, SchemaSymbols.ATT_MINOCCURS);
            Attr anyWcMaxOccurs = DOMUtil.getAttr(child, SchemaSymbols.ATT_MAXOCCURS);
            if (anyWcMinOccurs != null || anyWcMaxOccurs != null) {
                this.reportSchemaError("s4s-att-not-allowed", new Object[]{DOMUtil.getLocalName(elmNode) + "=>" + SchemaSymbols.ELT_ANY, SchemaSymbols.ATT_MINOCCURS + "|" + SchemaSymbols.ATT_MAXOCCURS}, child);
            }
            Object[] wcAttrValues = this.fAttrChecker.checkAttributes(child, false, schemaDoc);
            ocDecl.fWildcard = this.fSchemaHandler.fWildCardTraverser.traverseWildcardDecl(child, wcAttrValues, schemaDoc, grammar);
            this.fAttrChecker.returnAttrArray(wcAttrValues, schemaDoc);
            if (ocMode == 0) {
                ocDecl.fWildcard = null;
                this.reportSchemaError("src-ct11.3", new Object[]{this.fName}, elmNode);
            }
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return ocDecl;
    }

    private XSComplexTypeDecl traverseComplexTypeDecl(Element complexTypeDecl, String complexTypeName, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar, XSObject context) {
        this.fComplexTypeDecl = new XSComplexTypeDecl();
        this.fAttrGrp = new XSAttributeGroupDecl();
        Boolean abstractAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_ABSTRACT];
        XInt blockAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_BLOCK];
        Boolean mixedAtt = (Boolean)attrValues[XSAttributeChecker.ATTIDX_MIXED];
        XInt finalAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
        this.fName = complexTypeName;
        this.fComplexTypeDecl.setName(this.fName);
        this.fTargetNamespace = schemaDoc.fTargetNamespace;
        this.fBlock = blockAtt == null ? schemaDoc.fBlockDefault : blockAtt.shortValue();
        this.fFinal = finalAtt == null ? schemaDoc.fFinalDefault : finalAtt.shortValue();
        this.fBlock = (short)(this.fBlock & 3);
        this.fFinal = (short)(this.fFinal & 3);
        this.fIsAbstract = abstractAtt != null && abstractAtt != false;
        this.fAnnotations = null;
        this.fOpenContent = null;
        this.fAssertions = null;
        Element child = null;
        try {
            String text;
            Boolean defaultAttributeAppliesAttr;
            if (this.fSchemaHandler.fSchemaVersion == 4 && (defaultAttributeAppliesAttr = (Boolean)attrValues[XSAttributeChecker.ATTIDX_DEFAULTATTRAPPLY]).booleanValue() && schemaDoc.fDefaultAGroup != null) {
                this.mergeAttributes(schemaDoc.fDefaultAGroup, this.fAttrGrp, this.fName, true, complexTypeDecl);
            }
            if ((child = DOMUtil.getFirstChildElement(complexTypeDecl)) != null) {
                if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    this.addAnnotation(this.traverseAnnotationDecl(child, attrValues, false, schemaDoc));
                    child = DOMUtil.getNextSiblingElement(child);
                } else {
                    text = DOMUtil.getSyntheticAnnotation(complexTypeDecl);
                    if (text != null) {
                        this.addAnnotation(this.traverseSyntheticAnnotation(complexTypeDecl, text, attrValues, false, schemaDoc));
                    }
                }
                if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, child);
                }
            } else {
                text = DOMUtil.getSyntheticAnnotation(complexTypeDecl);
                if (text != null) {
                    this.addAnnotation(this.traverseSyntheticAnnotation(complexTypeDecl, text, attrValues, false, schemaDoc));
                }
            }
            if (child == null) {
                this.fBaseType = SchemaGrammar.getXSAnyType(this.fSchemaHandler.fSchemaVersion);
                this.fDerivedBy = (short)2;
                if (this.fSchemaHandler.fSchemaVersion == 4) {
                    this.fComplexTypeDecl.setBaseType(this.fBaseType);
                }
                this.processComplexContent(child, mixedAtt, false, schemaDoc, grammar);
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_SIMPLECONTENT)) {
                this.traverseSimpleContent(child, schemaDoc, grammar);
                Element elemTmp = DOMUtil.getNextSiblingElement(child);
                if (elemTmp != null) {
                    String siblingName = DOMUtil.getLocalName(elemTmp);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, siblingName}, elemTmp);
                }
            } else if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_COMPLEXCONTENT)) {
                boolean mixedAttPresent = this.fSchemaHandler.fSchemaVersion == 4 ? DOMUtil.getAttr(complexTypeDecl, SchemaSymbols.ATT_MIXED) != null : false;
                this.traverseComplexContent(child, mixedAtt, mixedAttPresent, schemaDoc, grammar);
                Element elemTmp = DOMUtil.getNextSiblingElement(child);
                if (elemTmp != null) {
                    String siblingName = DOMUtil.getLocalName(elemTmp);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, siblingName}, elemTmp);
                }
            } else {
                this.fBaseType = SchemaGrammar.getXSAnyType(this.fSchemaHandler.fSchemaVersion);
                this.fDerivedBy = (short)2;
                if (this.fSchemaHandler.fSchemaVersion == 4) {
                    this.fComplexTypeDecl.setBaseType(this.fBaseType);
                }
                this.processComplexContent(child, mixedAtt, false, schemaDoc, grammar);
            }
        }
        catch (ComplexTypeRecoverableError e) {
            this.handleComplexTypeError(e.getMessage(), e.errorSubstText, e.errorElem);
        }
        this.fComplexTypeDecl.setValues(this.fName, this.fTargetNamespace, this.fBaseType, this.fDerivedBy, this.fFinal, this.fBlock, this.fContentType, this.fIsAbstract, this.fAttrGrp, this.fXSSimpleType, this.fParticle, new XSObjectListImpl(this.fAnnotations, this.fAnnotations == null ? 0 : this.fAnnotations.length), this.fOpenContent);
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            this.fComplexTypeDecl.setContext(context);
        }
        this.fComplexTypeDecl.setAssertions(this.fAssertions != null ? new XSObjectListImpl(this.fAssertions, this.fAssertions.length) : null);
        return this.fComplexTypeDecl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traverseSimpleContent(Element simpleContentElement, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String text;
        Object[] simpleContentAttrValues = this.fAttrChecker.checkAttributes(simpleContentElement, false, schemaDoc);
        this.fContentType = 1;
        this.fParticle = null;
        Element simpleContent = DOMUtil.getFirstChildElement(simpleContentElement);
        if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.addAnnotation(this.traverseAnnotationDecl(simpleContent, simpleContentAttrValues, false, schemaDoc));
            simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
        } else {
            String text2 = DOMUtil.getSyntheticAnnotation(simpleContentElement);
            if (text2 != null) {
                this.addAnnotation(this.traverseSyntheticAnnotation(simpleContentElement, text2, simpleContentAttrValues, false, schemaDoc));
            }
        }
        if (simpleContent == null) {
            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.2", new Object[]{this.fName, SchemaSymbols.ELT_SIMPLECONTENT}, simpleContentElement);
        }
        String simpleContentName = DOMUtil.getLocalName(simpleContent);
        if (simpleContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else {
            if (!simpleContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, simpleContentName}, simpleContent);
            }
            this.fDerivedBy = 1;
            if (this.fSchemaHandler.fSchemaVersion == 4) {
                this.fComplexTypeDecl.setDerivationMethod((short)1);
            }
        }
        Element elemTmp = DOMUtil.getNextSiblingElement(simpleContent);
        if (elemTmp != null) {
            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
            String siblingName = DOMUtil.getLocalName(elemTmp);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, siblingName}, elemTmp);
        }
        Object[] derivationTypeAttrValues = this.fAttrChecker.checkAttributes(simpleContent, false, schemaDoc);
        QName baseTypeName = (QName)derivationTypeAttrValues[XSAttributeChecker.ATTIDX_BASE];
        if (baseTypeName == null) {
            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError("s4s-att-must-appear", new Object[]{simpleContentName, "base"}, simpleContent);
        }
        XSTypeDefinition type = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName, simpleContent);
        if (type == null) {
            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError();
        }
        this.fBaseType = type;
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            this.fComplexTypeDecl.setBaseType(this.fBaseType);
        }
        XSSimpleType baseValidator = null;
        XSComplexTypeDecl baseComplexType = null;
        short baseFinalSet = 0;
        if (type.getTypeCategory() == 15) {
            baseComplexType = (XSComplexTypeDecl)type;
            baseFinalSet = baseComplexType.getFinal();
            if (baseComplexType.getContentType() == 1) {
                baseValidator = (XSSimpleType)baseComplexType.getSimpleType();
            } else if (this.fDerivedBy != 2 || baseComplexType.getContentType() != 3 || !((XSParticleDecl)baseComplexType.getParticle()).emptiable()) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("src-ct.2.1", new Object[]{this.fName, baseComplexType.getName()}, simpleContent);
            }
        } else {
            baseValidator = (XSSimpleType)type;
            if (this.fDerivedBy == 2) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("src-ct.2.1", new Object[]{this.fName, baseValidator.getName()}, simpleContent);
            }
            baseFinalSet = baseValidator.getFinal();
        }
        if ((baseFinalSet & this.fDerivedBy) != 0) {
            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            String errorKey = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(errorKey, new Object[]{this.fName, this.fBaseType.getName()}, simpleContent);
        }
        Element scElement = simpleContent;
        if ((simpleContent = DOMUtil.getFirstChildElement(simpleContent)) != null) {
            if (DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.addAnnotation(this.traverseAnnotationDecl(simpleContent, derivationTypeAttrValues, false, schemaDoc));
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            } else {
                text = DOMUtil.getSyntheticAnnotation(scElement);
                if (text != null) {
                    this.addAnnotation(this.traverseSyntheticAnnotation(scElement, text, derivationTypeAttrValues, false, schemaDoc));
                }
            }
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, simpleContent);
            }
        } else {
            text = DOMUtil.getSyntheticAnnotation(scElement);
            if (text != null) {
                this.addAnnotation(this.traverseSyntheticAnnotation(scElement, text, derivationTypeAttrValues, false, schemaDoc));
            }
        }
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            this.addAssertsFromBaseTypes(this.fBaseType);
        }
        if (this.fDerivedBy == 2) {
            boolean needToSetContext = false;
            if (simpleContent != null && DOMUtil.getLocalName(simpleContent).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                XSSimpleType dv = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(simpleContent, schemaDoc, grammar, null);
                if (dv == null) {
                    this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                    this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                    throw new ComplexTypeRecoverableError();
                }
                if (baseValidator != null && !this.fSchemaHandler.fXSConstraints.checkSimpleDerivationOk(dv, baseValidator, baseValidator.getFinal())) {
                    this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                    this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                    throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.2.2.1", new Object[]{this.fName, dv.getName(), baseValidator.getName()}, simpleContent);
                }
                if (this.fSchemaHandler.fSchemaVersion == 4 && dv instanceof XSSimpleTypeDecl) {
                    needToSetContext = true;
                }
                baseValidator = dv;
                simpleContent = DOMUtil.getNextSiblingElement(simpleContent);
            } else if (baseValidator == SchemaGrammar.fAnySimpleType || baseValidator == SchemaGrammar.fAnyAtomicType) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("cos-st-restricts.1.1", new Object[]{baseValidator.getName(), this.genAnonTypeName(simpleContentElement)}, simpleContentElement);
            }
            if (baseValidator == null) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("src-ct.2.2", new Object[]{this.fName}, simpleContent);
            }
            Element attrOrAssertNode = null;
            XSFacets facetData = null;
            short presentFacets = 0;
            short fixedFacets = 0;
            if (simpleContent != null) {
                XSDAbstractTraverser.FacetInfo fi = this.traverseFacets(simpleContent, this.fComplexTypeDecl, baseValidator, schemaDoc);
                attrOrAssertNode = fi.nodeAfterFacets;
                facetData = fi.facetdata;
                presentFacets = fi.fPresentFacets;
                fixedFacets = fi.fFixedFacets;
            }
            String name = this.genAnonTypeName(simpleContentElement);
            this.fXSSimpleType = this.fSchemaHandler.fDVFactory.createTypeRestriction(name, schemaDoc.fTargetNamespace, (short)0, baseValidator, null);
            try {
                this.fValidationState.setNamespaceSupport(schemaDoc.fNamespaceSupport);
                this.fValidationState.setDatatypeXMLVersion(schemaDoc.fDatatypeXMLVersion);
                this.fXSSimpleType.applyFacets(facetData, presentFacets, fixedFacets, this.fValidationState);
            }
            catch (InvalidDatatypeFacetException ex) {
                this.reportSchemaError(ex.getKey(), ex.getArgs(), simpleContent);
                this.fXSSimpleType = this.fSchemaHandler.fDVFactory.createTypeRestriction(name, schemaDoc.fTargetNamespace, (short)0, baseValidator, null);
            }
            if (this.fXSSimpleType instanceof XSSimpleTypeDecl) {
                ((XSSimpleTypeDecl)this.fXSSimpleType).setAnonymous(true);
            }
            if (needToSetContext) {
                ((XSSimpleTypeDecl)baseValidator).setContext(this.fXSSimpleType);
            }
            if (attrOrAssertNode != null) {
                if (this.isAttrOrAttrGroup(attrOrAssertNode)) {
                    Element node = this.traverseAttrsAndAttrGrps(attrOrAssertNode, this.fAttrGrp, schemaDoc, grammar, this.fComplexTypeDecl);
                    if (node != null) {
                        if (!this.isAssert(node)) {
                            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(node)}, node);
                        }
                        this.traverseAsserts(node, schemaDoc, grammar, this.fComplexTypeDecl);
                    }
                } else {
                    if (!this.isAssert(attrOrAssertNode)) {
                        this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                        this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                        throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(attrOrAssertNode)}, attrOrAssertNode);
                    }
                    this.traverseAsserts(attrOrAssertNode, schemaDoc, grammar, this.fComplexTypeDecl);
                }
            }
            try {
                this.mergeAttributes(baseComplexType.getAttrGrp(), this.fAttrGrp, this.fName, false, simpleContentElement);
            }
            catch (ComplexTypeRecoverableError e) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw e;
            }
            this.fAttrGrp.removeProhibitedAttrs();
            Object[] errArgs = this.fAttrGrp.validRestrictionOf(this.fName, baseComplexType.getAttrGrp(), this.fSchemaHandler.fXSConstraints);
            if (errArgs != null) {
                this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError((String)errArgs[errArgs.length - 1], errArgs, attrOrAssertNode);
            }
        } else {
            this.fXSSimpleType = baseValidator;
            if (simpleContent != null) {
                Element attrOrAssertNode = simpleContent;
                if (this.isAttrOrAttrGroup(attrOrAssertNode)) {
                    Element node = this.traverseAttrsAndAttrGrps(attrOrAssertNode, this.fAttrGrp, schemaDoc, grammar, this.fComplexTypeDecl);
                    if (node != null) {
                        if (!this.isAssert(node)) {
                            this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(node)}, node);
                        }
                        this.traverseAsserts(node, schemaDoc, grammar, this.fComplexTypeDecl);
                    }
                } else {
                    if (!this.isAssert(attrOrAssertNode)) {
                        this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                        this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                        throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(attrOrAssertNode)}, attrOrAssertNode);
                    }
                    this.traverseAsserts(attrOrAssertNode, schemaDoc, grammar, this.fComplexTypeDecl);
                }
                this.fAttrGrp.removeProhibitedAttrs();
            }
            if (baseComplexType != null) {
                try {
                    this.mergeAttributes(baseComplexType.getAttrGrp(), this.fAttrGrp, this.fName, true, simpleContentElement);
                }
                catch (ComplexTypeRecoverableError e) {
                    this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
                    this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                    throw e;
                }
            }
        }
        this.fAttrChecker.returnAttrArray(simpleContentAttrValues, schemaDoc);
        this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void traverseComplexContent(Element complexContentElement, boolean mixedOnType, boolean mixedOnTypePresent, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String text;
        Object[] complexContentAttrValues = this.fAttrChecker.checkAttributes(complexContentElement, false, schemaDoc);
        boolean mixedContent = mixedOnType;
        Boolean mixedAtt = (Boolean)complexContentAttrValues[XSAttributeChecker.ATTIDX_MIXED];
        if (mixedAtt != null) {
            mixedContent = mixedAtt;
            if (mixedOnTypePresent && mixedContent != mixedOnType) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("src-ct11.4", new Object[]{this.fName}, complexContentElement);
            }
        }
        this.fXSSimpleType = null;
        Element complexContent = DOMUtil.getFirstChildElement(complexContentElement);
        if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.addAnnotation(this.traverseAnnotationDecl(complexContent, complexContentAttrValues, false, schemaDoc));
            complexContent = DOMUtil.getNextSiblingElement(complexContent);
        } else {
            String text2 = DOMUtil.getSyntheticAnnotation(complexContentElement);
            if (text2 != null) {
                this.addAnnotation(this.traverseSyntheticAnnotation(complexContentElement, text2, complexContentAttrValues, false, schemaDoc));
            }
        }
        if (complexContent == null) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.2", new Object[]{this.fName, SchemaSymbols.ELT_COMPLEXCONTENT}, complexContentElement);
        }
        String complexContentName = DOMUtil.getLocalName(complexContent);
        if (complexContentName.equals(SchemaSymbols.ELT_RESTRICTION)) {
            this.fDerivedBy = (short)2;
        } else {
            if (!complexContentName.equals(SchemaSymbols.ELT_EXTENSION)) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, complexContentName}, complexContent);
            }
            this.fDerivedBy = 1;
            if (this.fSchemaHandler.fSchemaVersion == 4) {
                this.fComplexTypeDecl.setDerivationMethod((short)1);
            }
        }
        Element elemTmp = DOMUtil.getNextSiblingElement(complexContent);
        if (elemTmp != null) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            String siblingName = DOMUtil.getLocalName(elemTmp);
            throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, siblingName}, elemTmp);
        }
        Object[] derivationTypeAttrValues = this.fAttrChecker.checkAttributes(complexContent, false, schemaDoc);
        QName baseTypeName = (QName)derivationTypeAttrValues[XSAttributeChecker.ATTIDX_BASE];
        if (baseTypeName == null) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError("s4s-att-must-appear", new Object[]{complexContentName, "base"}, complexContent);
        }
        XSTypeDefinition type = (XSTypeDefinition)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeName, complexContent);
        if (type == null) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError();
        }
        if (!(type instanceof XSComplexTypeDecl)) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            throw new ComplexTypeRecoverableError("src-ct.1", new Object[]{this.fName, type.getName()}, complexContent);
        }
        XSComplexTypeDecl baseType = (XSComplexTypeDecl)type;
        this.fBaseType = baseType;
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            this.fComplexTypeDecl.setBaseType(this.fBaseType);
        }
        if ((baseType.getFinal() & this.fDerivedBy) != 0) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            String errorKey = this.fDerivedBy == 1 ? "cos-ct-extends.1.1" : "derivation-ok-restriction.1";
            throw new ComplexTypeRecoverableError(errorKey, new Object[]{this.fName, this.fBaseType.getName()}, complexContent);
        }
        if ((complexContent = DOMUtil.getFirstChildElement(complexContent)) != null) {
            if (DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.addAnnotation(this.traverseAnnotationDecl(complexContent, derivationTypeAttrValues, false, schemaDoc));
                complexContent = DOMUtil.getNextSiblingElement(complexContent);
            } else {
                text = DOMUtil.getSyntheticAnnotation(complexContent);
                if (text != null) {
                    this.addAnnotation(this.traverseSyntheticAnnotation(complexContent, text, derivationTypeAttrValues, false, schemaDoc));
                }
            }
            if (complexContent != null && DOMUtil.getLocalName(complexContent).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, SchemaSymbols.ELT_ANNOTATION}, complexContent);
            }
        } else {
            text = DOMUtil.getSyntheticAnnotation(complexContent);
            if (text != null) {
                this.addAnnotation(this.traverseSyntheticAnnotation(complexContent, text, derivationTypeAttrValues, false, schemaDoc));
            }
        }
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            this.addAssertsFromBaseTypes(this.fBaseType);
        }
        try {
            this.processComplexContent(complexContent, mixedContent, true, schemaDoc, grammar);
        }
        catch (ComplexTypeRecoverableError e) {
            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
            throw e;
        }
        XSParticleDecl baseContent = (XSParticleDecl)baseType.getParticle();
        XSOpenContentDecl explicitOpenContent = null;
        if (this.fDerivedBy == 2) {
            Object[] errArgs;
            if (this.fContentType == 3 && baseType.getContentType() != 3) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError("derivation-ok-restriction.5.4.1.2", new Object[]{this.fName, baseType.getName()}, complexContent);
            }
            try {
                this.mergeAttributes(baseType.getAttrGrp(), this.fAttrGrp, this.fName, false, complexContent);
            }
            catch (ComplexTypeRecoverableError e) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw e;
            }
            this.fAttrGrp.removeProhibitedAttrs();
            if (baseType != SchemaGrammar.getXSAnyType(this.fSchemaHandler.fSchemaVersion) && (errArgs = this.fAttrGrp.validRestrictionOf(this.fName, baseType.getAttrGrp(), this.fSchemaHandler.fXSConstraints)) != null) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw new ComplexTypeRecoverableError((String)errArgs[errArgs.length - 1], errArgs, complexContent);
            }
        } else {
            block55: {
                if (this.fParticle == null) {
                    this.fContentType = baseType.getContentType();
                    this.fXSSimpleType = (XSSimpleType)baseType.getSimpleType();
                    this.fParticle = baseContent;
                    if (this.fSchemaHandler.fSchemaVersion == 4) {
                        explicitOpenContent = (XSOpenContentDecl)baseType.getOpenContent();
                    }
                } else if (baseType.getContentType() != 0) {
                    boolean derivedIsAll;
                    if (this.fContentType == 2 && baseType.getContentType() != 2) {
                        this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                        this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                        throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.1.a", new Object[]{this.fName}, complexContent);
                    }
                    if (this.fContentType == 3 && baseType.getContentType() != 3) {
                        this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                        this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                        throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.1.b", new Object[]{this.fName}, complexContent);
                    }
                    boolean baseIsAll = ((XSParticleDecl)baseType.getParticle()).fType == 3 && ((XSModelGroupImpl)((XSParticleDecl)baseType.getParticle()).fValue).fCompositor == 103;
                    boolean bl = derivedIsAll = this.fParticle.fType == 3 && ((XSModelGroupImpl)this.fParticle.fValue).fCompositor == 103;
                    if (baseIsAll || derivedIsAll) {
                        if (this.fSchemaHandler.fSchemaVersion == 4 && baseIsAll && derivedIsAll) {
                            if (this.fParticle.fMinOccurs != baseContent.fMinOccurs) {
                                throw new ComplexTypeRecoverableError("cos-particle-extends.3.1", new Object[0], complexContent);
                            }
                            XSModelGroupImpl group = new XSModelGroupImpl();
                            group.fCompositor = (short)103;
                            group.fParticleCount = ((XSModelGroupImpl)baseContent.fValue).fParticleCount + ((XSModelGroupImpl)this.fParticle.fValue).fParticleCount;
                            group.fParticles = new XSParticleDecl[group.fParticleCount];
                            System.arraycopy(((XSModelGroupImpl)baseContent.fValue).fParticles, 0, group.fParticles, 0, ((XSModelGroupImpl)baseContent.fValue).fParticleCount);
                            System.arraycopy(((XSModelGroupImpl)this.fParticle.fValue).fParticles, 0, group.fParticles, ((XSModelGroupImpl)baseContent.fValue).fParticleCount, ((XSModelGroupImpl)this.fParticle.fValue).fParticleCount);
                            group.fAnnotations = XSObjectListImpl.EMPTY_LIST;
                            XSParticleDecl particle = new XSParticleDecl();
                            particle.fType = (short)3;
                            particle.fValue = group;
                            particle.fAnnotations = XSObjectListImpl.EMPTY_LIST;
                            particle.fMinOccurs = this.fParticle.fMinOccurs;
                            this.fParticle = particle;
                            explicitOpenContent = (XSOpenContentDecl)baseType.getOpenContent();
                            break block55;
                        } else {
                            this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                            this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                            throw new ComplexTypeRecoverableError("cos-all-limited.1.2", new Object[0], complexContent);
                        }
                    }
                    XSModelGroupImpl group = new XSModelGroupImpl();
                    group.fCompositor = (short)102;
                    group.fParticleCount = 2;
                    group.fParticles = new XSParticleDecl[2];
                    group.fParticles[0] = (XSParticleDecl)baseType.getParticle();
                    group.fParticles[1] = this.fParticle;
                    group.fAnnotations = XSObjectListImpl.EMPTY_LIST;
                    XSParticleDecl particle = new XSParticleDecl();
                    particle.fType = (short)3;
                    particle.fValue = group;
                    particle.fAnnotations = XSObjectListImpl.EMPTY_LIST;
                    this.fParticle = particle;
                    if (this.fSchemaHandler.fSchemaVersion == 4) {
                        explicitOpenContent = (XSOpenContentDecl)baseType.getOpenContent();
                    }
                }
            }
            this.fAttrGrp.removeProhibitedAttrs();
            try {
                this.mergeAttributes(baseType.getAttrGrp(), this.fAttrGrp, this.fName, true, complexContent);
            }
            catch (ComplexTypeRecoverableError e) {
                this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                throw e;
            }
        }
        if (this.fSchemaHandler.fSchemaVersion == 4) {
            XSOpenContentDecl baseOpenContent = (XSOpenContentDecl)baseType.getOpenContent();
            if (this.fOpenContent == null && schemaDoc.fDefaultOpenContent != null && (this.fContentType != 0 || schemaDoc.fDefaultOpenContent.fAppliesToEmpty)) {
                this.fOpenContent = schemaDoc.fDefaultOpenContent;
            }
            if (this.fOpenContent == null || this.fOpenContent.fMode == 0) {
                this.fOpenContent = explicitOpenContent;
            } else {
                if (this.fContentType == 0) {
                    this.fParticle = XSConstraints.getEmptySequence();
                    this.fContentType = (short)2;
                }
                if (explicitOpenContent != null && this.fOpenContent.fWildcard != null) {
                    XSOpenContentDecl oc = new XSOpenContentDecl();
                    oc.fMode = this.fOpenContent.fMode;
                    oc.fWildcard = this.fSchemaHandler.fXSConstraints.performUnionWith(this.fOpenContent.fWildcard, explicitOpenContent.fWildcard, this.fOpenContent.fWildcard.fProcessContents);
                    oc.fWildcard.fAnnotations = this.fOpenContent.fWildcard.fAnnotations;
                    this.fOpenContent = oc;
                }
            }
            if (this.fDerivedBy == 1 && baseType.getContentType() != 0 && baseOpenContent != null && this.fOpenContent != baseOpenContent) {
                if (this.fOpenContent == null) {
                    this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                    this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.3", new Object[]{this.fName}, complexContent);
                }
                if (this.fOpenContent.fMode == 2 && baseOpenContent.fMode != 2) {
                    this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                    this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.3.3", new Object[]{this.fName}, complexContent);
                }
                if (!this.fSchemaHandler.fXSConstraints.isSubsetOf(baseOpenContent.fWildcard, this.fOpenContent.fWildcard)) {
                    this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
                    this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
                    throw new ComplexTypeRecoverableError("cos-ct-extends.1.4.3.2.2.3.4", new Object[]{this.fName}, complexContent);
                }
            }
        }
        this.fAttrChecker.returnAttrArray(complexContentAttrValues, schemaDoc);
        this.fAttrChecker.returnAttrArray(derivationTypeAttrValues, schemaDoc);
    }

    private void mergeAttributes(XSAttributeGroupDecl fromAttrGrp, XSAttributeGroupDecl toAttrGrp, String typeName, boolean extension, Element elem) throws ComplexTypeRecoverableError {
        XSObjectList attrUseS = fromAttrGrp.getAttributeUses();
        XSAttributeUseImpl oneAttrUse = null;
        int attrCount = attrUseS.getLength();
        for (int i = 0; i < attrCount; ++i) {
            oneAttrUse = (XSAttributeUseImpl)attrUseS.item(i);
            XSAttributeUse existingAttrUse = toAttrGrp.getAttributeUse(oneAttrUse.fAttrDecl.getNamespace(), oneAttrUse.fAttrDecl.getName());
            if (existingAttrUse == null) {
                String idName = toAttrGrp.addAttributeUse(oneAttrUse, this.fSchemaHandler.fSchemaVersion == 4);
                if (idName == null) continue;
                throw new ComplexTypeRecoverableError("ct-props-correct.5", new Object[]{typeName, idName, oneAttrUse.fAttrDecl.getName()}, elem);
            }
            if (existingAttrUse == oneAttrUse || !extension) continue;
            this.reportSchemaError("ct-props-correct.4", new Object[]{typeName, oneAttrUse.fAttrDecl.getName()}, elem);
            toAttrGrp.replaceAttributeUse(existingAttrUse, oneAttrUse);
        }
        if (extension) {
            if (toAttrGrp.fAttributeWC == null) {
                toAttrGrp.fAttributeWC = fromAttrGrp.fAttributeWC;
            } else if (fromAttrGrp.fAttributeWC != null) {
                toAttrGrp.fAttributeWC = this.fSchemaHandler.fXSConstraints.performUnionWith(toAttrGrp.fAttributeWC, fromAttrGrp.fAttributeWC, toAttrGrp.fAttributeWC.fProcessContents);
                if (toAttrGrp.fAttributeWC == null) {
                    throw new ComplexTypeRecoverableError("src-ct.5", new Object[]{typeName}, elem);
                }
            }
        }
    }

    private void addAssertsFromBaseTypes(XSTypeDefinition baseSchemaType) {
        if (baseSchemaType != null) {
            XSTypeDefinition ancestorType;
            if (baseSchemaType instanceof XSComplexTypeDefinition) {
                XSObjectList assertList = ((XSComplexTypeDefinition)baseSchemaType).getAssertions();
                for (int assertLstIdx = 0; assertLstIdx < assertList.size(); ++assertLstIdx) {
                    if (this.assertExists((XSAssertImpl)assertList.get(assertLstIdx))) continue;
                    this.addAssertion((XSAssertImpl)assertList.get(assertLstIdx));
                }
            } else if (baseSchemaType instanceof XSSimpleTypeDefinition) {
                XSObjectList facets = ((XSSimpleTypeDefinition)baseSchemaType).getMultiValueFacets();
                for (int facetIdx = 0; facetIdx < facets.getLength(); ++facetIdx) {
                    XSMultiValueFacet facet = (XSMultiValueFacet)facets.item(facetIdx);
                    if (facet.getFacetKind() != 16384) continue;
                    Vector assertionFacets = facet.getAsserts();
                    for (int j = 0; j < assertionFacets.size(); ++j) {
                        XSAssertImpl assertImpl = (XSAssertImpl)assertionFacets.get(j);
                        this.addAssertion(assertImpl);
                    }
                    break;
                }
            }
            if ((ancestorType = baseSchemaType.getBaseType()) != null && !XS11TypeHelper.getSchemaTypeName(ancestorType).equals("anyType") && !ancestorType.derivedFrom(Constants.NS_XMLSCHEMA, "anyAtomicType", (short)2)) {
                this.addAssertsFromBaseTypes(ancestorType);
            }
        }
    }

    private boolean assertExists(XSAssertImpl assertVal) {
        boolean assertExists = false;
        if (this.fAssertions != null) {
            for (int i = 0; i < this.fAssertions.length; ++i) {
                if (!this.fAssertions[i].equals(assertVal)) continue;
                assertExists = true;
                break;
            }
        }
        return assertExists;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processComplexContent(Element complexContentChild, boolean isMixed, boolean isDerivation, XSDocumentInfo schemaDoc, SchemaGrammar grammar) throws ComplexTypeRecoverableError {
        String childName;
        Element attrOrAssertNode = null;
        XSParticleDecl particle = null;
        boolean emptyParticle = false;
        String string = childName = complexContentChild != null ? DOMUtil.getLocalName(complexContentChild) : null;
        if (this.fSchemaHandler.fSchemaVersion == 4 && childName != null && childName.equals(SchemaSymbols.ELT_OPENCONTENT)) {
            this.fOpenContent = this.traverseOpenContent(complexContentChild, schemaDoc, grammar, false);
            String string2 = childName = (complexContentChild = DOMUtil.getNextSiblingElement(complexContentChild)) != null ? DOMUtil.getLocalName(complexContentChild) : null;
        }
        if (childName != null) {
            XSModelGroupImpl group;
            if (childName.equals(SchemaSymbols.ELT_GROUP)) {
                particle = this.fSchemaHandler.fGroupTraverser.traverseLocal(complexContentChild, schemaDoc, grammar);
                attrOrAssertNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(complexContentChild, schemaDoc, grammar, 0, this.fComplexTypeDecl);
                if (particle != null) {
                    group = (XSModelGroupImpl)particle.fValue;
                    if (group.fParticleCount == 0) {
                        emptyParticle = true;
                    }
                }
                attrOrAssertNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(complexContentChild, schemaDoc, grammar, 0, this.fComplexTypeDecl);
                if (particle != null && particle.fMinOccurs == 0) {
                    group = (XSModelGroupImpl)particle.fValue;
                    if (group.fParticleCount == 0) {
                        emptyParticle = true;
                    }
                }
                attrOrAssertNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else if (childName.equals(SchemaSymbols.ELT_ALL)) {
                particle = this.traverseAll(complexContentChild, schemaDoc, grammar, 8, this.fComplexTypeDecl);
                if (particle != null) {
                    group = (XSModelGroupImpl)particle.fValue;
                    if (group.fParticleCount == 0) {
                        emptyParticle = true;
                    }
                }
                attrOrAssertNode = DOMUtil.getNextSiblingElement(complexContentChild);
            } else {
                attrOrAssertNode = complexContentChild;
            }
        }
        if (emptyParticle) {
            Element child = DOMUtil.getFirstChildElement(complexContentChild);
            if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                child = DOMUtil.getNextSiblingElement(child);
            }
            if (child == null) {
                particle = null;
            }
        }
        if (particle == null && isMixed) {
            particle = XSConstraints.getEmptySequence();
        }
        if (this.fSchemaHandler.fSchemaVersion == 4 && !isDerivation) {
            if (this.fOpenContent == null) {
                if (schemaDoc.fDefaultOpenContent != null && (particle != null || schemaDoc.fDefaultOpenContent.fAppliesToEmpty)) {
                    this.fOpenContent = schemaDoc.fDefaultOpenContent;
                }
            } else if (this.fOpenContent.fMode == 0) {
                this.fOpenContent = null;
            }
        }
        if (particle == null && !isDerivation && this.fOpenContent != null) {
            particle = XSConstraints.getEmptySequence();
        }
        this.fParticle = particle;
        this.fContentType = this.fParticle == null ? (short)0 : (isMixed ? (short)3 : (short)2);
        if (attrOrAssertNode == null) return;
        if (this.isAttrOrAttrGroup(attrOrAssertNode)) {
            Element node = this.traverseAttrsAndAttrGrps(attrOrAssertNode, this.fAttrGrp, schemaDoc, grammar, this.fComplexTypeDecl);
            if (!isDerivation) {
                this.fAttrGrp.removeProhibitedAttrs();
            }
            if (node == null) return;
            if (!this.isAssert(node)) throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(node)}, node);
            this.traverseAsserts(node, schemaDoc, grammar, this.fComplexTypeDecl);
            return;
        } else {
            if (!this.isAssert(attrOrAssertNode)) throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(attrOrAssertNode)}, attrOrAssertNode);
            this.traverseAsserts(attrOrAssertNode, schemaDoc, grammar, this.fComplexTypeDecl);
        }
    }

    private boolean isAttrOrAttrGroup(Element e) {
        String elementName = DOMUtil.getLocalName(e);
        return elementName.equals(SchemaSymbols.ELT_ATTRIBUTE) || elementName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || elementName.equals(SchemaSymbols.ELT_ANYATTRIBUTE);
    }

    private boolean isAssert(Element e) {
        return this.fSchemaHandler.fSchemaVersion == 4 && DOMUtil.getLocalName(e).equals(SchemaSymbols.ELT_ASSERT);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void traverseAsserts(Element assertElement, XSDocumentInfo schemaDoc, SchemaGrammar grammar, XSComplexTypeDecl enclosingCT) throws ComplexTypeRecoverableError {
        Object[] attrValues = this.fAttrChecker.checkAttributes(assertElement, false, schemaDoc);
        String testStr = (String)attrValues[XSAttributeChecker.ATTIDX_XPATH];
        if (testStr != null) {
            Element childNode = DOMUtil.getFirstChildElement(assertElement);
            XSAnnotationImpl annotation = null;
            if (childNode != null) {
                if (DOMUtil.getLocalName(childNode).equals(SchemaSymbols.ELT_ANNOTATION)) {
                    annotation = this.traverseAnnotationDecl(childNode, attrValues, false, schemaDoc);
                    if ((childNode = DOMUtil.getNextSiblingElement(childNode)) != null) {
                        this.reportSchemaError("s4s-elt-invalid-content.1", new Object[]{DOMUtil.getLocalName(assertElement), DOMUtil.getLocalName(childNode)}, childNode);
                    }
                } else {
                    String text = DOMUtil.getSyntheticAnnotation(childNode);
                    if (text != null) {
                        annotation = this.traverseSyntheticAnnotation(childNode, text, attrValues, false, schemaDoc);
                    }
                }
            }
            XSObjectListImpl annotations = null;
            if (annotation != null) {
                annotations = new XSObjectListImpl();
                annotations.addXSObject(annotation);
            } else {
                annotations = XSObjectListImpl.EMPTY_LIST;
            }
            XSAssertImpl assertImpl = new XSAssertImpl(enclosingCT, annotations, this.fSchemaHandler);
            Test testExpr = new Test(testStr, schemaDoc.fNamespaceSupport, assertImpl);
            String xpathDefaultNamespace = this.getXPathDefaultNamespaceForAssert(assertElement, schemaDoc, attrValues);
            assertImpl.setTest(testExpr, assertElement);
            assertImpl.setXPathDefaultNamespace(xpathDefaultNamespace);
            assertImpl.setXPath2NamespaceContext(new SchemaNamespaceSupport(schemaDoc.fNamespaceSupport));
            String assertMessage = XMLChar.trim(assertElement.getAttributeNS(SchemaSymbols.URI_XERCES_EXTENSIONS, SchemaSymbols.ATT_ASSERT_MESSAGE));
            if (!"".equals(assertMessage)) {
                assertImpl.setMessage(assertMessage);
            }
            this.addAssertion(assertImpl);
            Element sibling = DOMUtil.getNextSiblingElement(assertElement);
            if (sibling != null) {
                if (!sibling.getLocalName().equals(SchemaSymbols.ELT_ASSERT)) {
                    this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
                    throw new ComplexTypeRecoverableError("s4s-elt-invalid-content.1", new Object[]{this.fName, DOMUtil.getLocalName(sibling)}, sibling);
                }
                this.traverseAsserts(sibling, schemaDoc, grammar, enclosingCT);
            }
        } else {
            this.reportSchemaError("src-assert.3.13.1", new Object[]{DOMUtil.getLocalName(assertElement), XS11TypeHelper.getSchemaTypeName(enclosingCT)}, assertElement);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
    }

    private String getXPathDefaultNamespaceForAssert(Element assertElement, XSDocumentInfo schemaDoc, Object[] attrValues) {
        Element schemaElementName;
        Attr xpathDefNamespaceAttrNode;
        String xpathDefaultNamespace = (String)attrValues[XSAttributeChecker.ATTIDX_XPATHDEFAULTNS];
        if (xpathDefaultNamespace == null) {
            if (schemaDoc.fXpathDefaultNamespaceIs2PoundDefault) {
                xpathDefaultNamespace = schemaDoc.fValidationContext.getURI(XMLSymbols.EMPTY_STRING);
                if (xpathDefaultNamespace != null) {
                    xpathDefaultNamespace = this.fSymbolTable.addSymbol(xpathDefaultNamespace);
                }
            } else {
                xpathDefaultNamespace = schemaDoc.fXpathDefaultNamespace;
            }
        }
        if (xpathDefaultNamespace == null && (xpathDefNamespaceAttrNode = (schemaElementName = assertElement.getOwnerDocument().getDocumentElement()).getAttributeNode(SchemaSymbols.ATT_XPATH_DEFAULT_NS)) != null) {
            xpathDefaultNamespace = xpathDefNamespaceAttrNode.getValue();
            if ("##targetNamespace".equals(xpathDefaultNamespace)) {
                xpathDefaultNamespace = schemaDoc.fTargetNamespace;
            } else if ("##defaultNamespace".equals(xpathDefaultNamespace)) {
                xpathDefaultNamespace = schemaDoc.fValidationContext.getURI(XMLSymbols.EMPTY_STRING);
                if (xpathDefaultNamespace != null) {
                    xpathDefaultNamespace = this.fSymbolTable.addSymbol(xpathDefaultNamespace);
                }
                attrValues[XSAttributeChecker.ATTIDX_XPATHDEFAULTNS_TWOPOUNDDFLT] = Boolean.TRUE;
            } else if (!xpathDefaultNamespace.equals("##local")) {
                try {
                    AnyURIDV anyUriDV = new AnyURIDV();
                    ((TypeValidator)anyUriDV).getActualValue(xpathDefaultNamespace, schemaDoc.fValidationContext);
                    xpathDefaultNamespace = this.fSymbolTable.addSymbol(xpathDefaultNamespace);
                }
                catch (InvalidDatatypeValueException ide) {
                    this.reportSchemaError("cvc-datatype-valid.1.2.3", new Object[]{xpathDefaultNamespace, "anyURI | ##defaultNamespace | ##targetNamespace | ##local"}, assertElement);
                }
            }
        }
        return xpathDefaultNamespace;
    }

    private String genAnonTypeName(Element complexTypeDecl) {
        StringBuffer typeName = new StringBuffer("#AnonType_");
        Element node = DOMUtil.getParent(complexTypeDecl);
        while (node != null && node != DOMUtil.getRoot(DOMUtil.getDocument(node))) {
            typeName.append(node.getAttribute(SchemaSymbols.ATT_NAME));
            node = DOMUtil.getParent(node);
        }
        return typeName.toString();
    }

    private void handleComplexTypeError(String messageId, Object[] args, Element e) {
        if (messageId != null) {
            this.reportSchemaError(messageId, args, e);
        }
        this.fBaseType = SchemaGrammar.getXSAnyType(this.fSchemaHandler.fSchemaVersion);
        this.fContentType = (short)3;
        this.fXSSimpleType = null;
        this.fParticle = XSDComplexTypeTraverser.getErrorContent();
        this.fAttrGrp.fAttributeWC = XSDComplexTypeTraverser.getErrorWildcard();
    }

    private void contentBackup() {
        if (this.fGlobalStore == null) {
            this.fGlobalStore = new Object[13];
            this.fGlobalStorePos = 0;
        }
        if (this.fGlobalStorePos == this.fGlobalStore.length) {
            Object[] newArray = new Object[this.fGlobalStorePos + 13];
            System.arraycopy(this.fGlobalStore, 0, newArray, 0, this.fGlobalStorePos);
            this.fGlobalStore = newArray;
        }
        this.fGlobalStore[this.fGlobalStorePos++] = this.fComplexTypeDecl;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fIsAbstract ? Boolean.TRUE : Boolean.FALSE;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fName;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fTargetNamespace;
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fDerivedBy << 16) + this.fFinal);
        this.fGlobalStore[this.fGlobalStorePos++] = new Integer((this.fBlock << 16) + this.fContentType);
        this.fGlobalStore[this.fGlobalStorePos++] = this.fBaseType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAttrGrp;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fParticle;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fXSSimpleType;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAnnotations;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fOpenContent;
        this.fGlobalStore[this.fGlobalStorePos++] = this.fAssertions;
    }

    private void contentRestore() {
        this.fAssertions = (XSAssertImpl[])this.fGlobalStore[--this.fGlobalStorePos];
        this.fOpenContent = (XSOpenContentDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fAnnotations = (XSAnnotationImpl[])this.fGlobalStore[--this.fGlobalStorePos];
        this.fXSSimpleType = (XSSimpleType)this.fGlobalStore[--this.fGlobalStorePos];
        this.fParticle = (XSParticleDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fAttrGrp = (XSAttributeGroupDecl)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBaseType = (XSTypeDefinition)this.fGlobalStore[--this.fGlobalStorePos];
        int i = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fBlock = (short)(i >> 16);
        this.fContentType = (short)i;
        i = (Integer)this.fGlobalStore[--this.fGlobalStorePos];
        this.fDerivedBy = (short)(i >> 16);
        this.fFinal = (short)i;
        this.fTargetNamespace = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fName = (String)this.fGlobalStore[--this.fGlobalStorePos];
        this.fIsAbstract = (Boolean)this.fGlobalStore[--this.fGlobalStorePos];
        this.fComplexTypeDecl = (XSComplexTypeDecl)this.fGlobalStore[--this.fGlobalStorePos];
    }

    private void addAnnotation(XSAnnotationImpl annotation) {
        if (annotation == null) {
            return;
        }
        if (this.fAnnotations == null) {
            this.fAnnotations = new XSAnnotationImpl[1];
        } else {
            XSAnnotationImpl[] tempArray = new XSAnnotationImpl[this.fAnnotations.length + 1];
            System.arraycopy(this.fAnnotations, 0, tempArray, 0, this.fAnnotations.length);
            this.fAnnotations = tempArray;
        }
        this.fAnnotations[this.fAnnotations.length - 1] = annotation;
    }

    private void addAssertion(XSAssertImpl assertion) {
        if (assertion == null) {
            return;
        }
        if (this.fAssertions == null) {
            this.fAssertions = new XSAssertImpl[1];
        } else {
            XSAssertImpl[] tempArray = new XSAssertImpl[this.fAssertions.length + 1];
            System.arraycopy(this.fAssertions, 0, tempArray, 0, this.fAssertions.length);
            this.fAssertions = tempArray;
        }
        this.fAssertions[this.fAssertions.length - 1] = assertion;
    }

    private static final class ComplexTypeRecoverableError
    extends Exception {
        private static final long serialVersionUID = 6802729912091130335L;
        Object[] errorSubstText = null;
        Element errorElem = null;

        ComplexTypeRecoverableError() {
        }

        ComplexTypeRecoverableError(String msgKey, Object[] args, Element e) {
            super(msgKey);
            this.errorSubstText = args;
            this.errorElem = e;
        }
    }
}

