/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.resource.common;

import bitronix.tm.resource.common.StateChangeListener;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.utils.Decoder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXAStatefulHolder
implements XAStatefulHolder {
    private static final Logger log = LoggerFactory.getLogger(AbstractXAStatefulHolder.class);
    private volatile int state = 1;
    private final List<StateChangeListener> stateChangeEventListeners = new ArrayList<StateChangeListener>();

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public void setState(int state) {
        int oldState = this.state;
        this.fireStateChanging(oldState, state);
        if (oldState == state) {
            throw new IllegalArgumentException("cannot switch state from " + Decoder.decodeXAStatefulHolderState(oldState) + " to " + Decoder.decodeXAStatefulHolderState(state));
        }
        if (log.isDebugEnabled()) {
            log.debug("state changing from " + Decoder.decodeXAStatefulHolderState(oldState) + " to " + Decoder.decodeXAStatefulHolderState(state) + " in " + this);
        }
        this.state = state;
        this.fireStateChanged(oldState, state);
    }

    @Override
    public void addStateChangeEventListener(StateChangeListener listener) {
        this.stateChangeEventListeners.add(listener);
    }

    @Override
    public void removeStateChangeEventListener(StateChangeListener listener) {
        this.stateChangeEventListeners.remove(listener);
    }

    private void fireStateChanging(int currentState, int futureState) {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.stateChangeEventListeners.size() + " stateChangeEventListener(s) about state changing from " + Decoder.decodeXAStatefulHolderState(currentState) + " to " + Decoder.decodeXAStatefulHolderState(futureState) + " in " + this);
        }
        for (StateChangeListener stateChangeListener : this.stateChangeEventListeners) {
            stateChangeListener.stateChanging(this, currentState, futureState);
        }
    }

    private void fireStateChanged(int oldState, int newState) {
        if (log.isDebugEnabled()) {
            log.debug("notifying " + this.stateChangeEventListeners.size() + " stateChangeEventListener(s) about state changed from " + Decoder.decodeXAStatefulHolderState(oldState) + " to " + Decoder.decodeXAStatefulHolderState(newState) + " in " + this);
        }
        for (StateChangeListener stateChangeListener : this.stateChangeEventListeners) {
            stateChangeListener.stateChanged(this, oldState, newState);
        }
    }
}

