/*
 * Decompiled with CFR 0.152.
 */
package bitronix.tm.utils;

import bitronix.tm.TransactionManagerServices;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManagementRegistrar {
    private static final Logger log = LoggerFactory.getLogger(ManagementRegistrar.class);

    private ManagementRegistrar() {
    }

    public static String makeValidName(String name) {
        return name.replaceAll("[\\:\\,\\=,\\.]", "_");
    }

    public static void register(String name, Object obj) {
        MBeanServer mbeanServer = ManagementRegistrar.getMBeanServer();
        if (mbeanServer == null) {
            return;
        }
        try {
            mbeanServer.registerMBean(obj, new ObjectName(name));
        }
        catch (Exception ex) {
            log.warn("cannot register object with name " + name, (Throwable)ex);
        }
    }

    public static void unregister(String name) {
        MBeanServer mbeanServer = ManagementRegistrar.getMBeanServer();
        if (mbeanServer == null) {
            return;
        }
        try {
            mbeanServer.unregisterMBean(new ObjectName(name));
        }
        catch (Exception ex) {
            log.warn("cannot unregister object with name " + name, (Throwable)ex);
        }
    }

    private static MBeanServer getMBeanServer() {
        if (!TransactionManagerServices.getConfiguration().isDisableJmx()) {
            return ManagementFactory.getPlatformMBeanServer();
        }
        return null;
    }
}

