/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata.util;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeResolver {
    public static Class<?>[] getSuperInterfaces(Class<?> type) {
        if (!type.isInterface()) {
            throw new IllegalArgumentException("only interfaces allowed");
        }
        LinkedList superInterfaces = new LinkedList();
        TypeResolver.collectSuperInterfaces(type, superInterfaces);
        return superInterfaces.toArray(new Class[superInterfaces.size()]);
    }

    private static void collectSuperInterfaces(Class<?> type, List<Class<?>> superInterfaces) {
        for (Class<?> superInterface : type.getInterfaces()) {
            superInterfaces.add(superInterface);
            TypeResolver.collectSuperInterfaces(superInterface, superInterfaces);
        }
    }

    public static ParameterizedType getGenericSuperclass(Class<?> type, Class<?> declaredType) {
        ArrayList<Type> types = new ArrayList<Type>();
        if (type.getGenericSuperclass() != null) {
            types.add(type.getGenericSuperclass());
        }
        types.addAll(Arrays.asList(type.getGenericInterfaces()));
        for (Type superType : types) {
            ParameterizedType parameterizedType;
            Type raw;
            if (!(superType instanceof ParameterizedType) || !((raw = (parameterizedType = (ParameterizedType)superType).getRawType()) instanceof Class) || !declaredType.isAssignableFrom((Class)raw)) continue;
            return parameterizedType;
        }
        return null;
    }

    public static Class<?> getSuperclass(Class<?> type, Class<?> declaredType) {
        ArrayList types = new ArrayList();
        if (type.getSuperclass() != null) {
            types.add(type.getSuperclass());
        }
        types.addAll(Arrays.asList(type.getInterfaces()));
        for (Class clazz : types) {
            if (!declaredType.isAssignableFrom(clazz)) continue;
            return clazz;
        }
        return null;
    }

    public static Map<TypeVariable<?>, Type> resolveVariables(Type type) {
        if (!(type instanceof Class) && !(type instanceof ParameterizedType)) {
            throw new IllegalArgumentException("Invalid type " + type);
        }
        HashMap map = new HashMap();
        Class<?> raw = TypeResolver.erase(type);
        TypeVariable<Class<?>>[] formal = raw.getTypeParameters();
        TypeVariable<Class<?>>[] actaul = type instanceof Class ? formal : ((ParameterizedType)type).getActualTypeArguments();
        for (int i = 0; i < formal.length; ++i) {
            map.put(formal[i], actaul[i]);
        }
        if (raw.getGenericSuperclass() != null) {
            map.putAll(TypeResolver.resolveVariables(raw.getGenericSuperclass()));
        }
        for (Type genericInterface : raw.getGenericInterfaces()) {
            map.putAll(TypeResolver.resolveVariables(genericInterface));
        }
        return map;
    }

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return TypeResolver.erase(parameterizedType.getRawType());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVar = (TypeVariable)type;
            Type[] bounds = typeVar.getBounds();
            if (bounds.length > 0) {
                return TypeResolver.erase(bounds[0]);
            }
            return Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wildType = (WildcardType)type;
            Type[] bounds = wildType.getUpperBounds();
            if (bounds.length > 1) {
                return TypeResolver.erase(bounds[0]);
            }
            return Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArray = (GenericArrayType)type;
            Class<?> componentClass = TypeResolver.erase(genericArray.getGenericComponentType());
            return Array.newInstance(componentClass, 0).getClass();
        }
        throw new IllegalArgumentException("Unknown type " + type);
    }
}

