/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.metadata;

import java.util.List;
import org.mule.common.metadata.MetaDataModel;
import org.mule.common.metadata.MetaDataModelProperty;
import org.mule.common.metadata.MetaDataPropertyManager;
import org.mule.common.metadata.datatype.DataType;

public abstract class AbstractMetaDataModel
implements MetaDataModel {
    private String implementationClass;
    private DataType dataType;
    private MetaDataPropertyManager<MetaDataModelProperty> metaDataModelPropertiesManager;

    protected AbstractMetaDataModel(DataType dataType) {
        this.dataType = dataType;
        this.metaDataModelPropertiesManager = new MetaDataPropertyManager();
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public <T extends MetaDataModel> T as(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return (T)((MetaDataModel)clazz.cast(this));
        }
        return null;
    }

    protected void addAllProperties(MetaDataModelProperty[] properties) {
        for (MetaDataModelProperty property : properties) {
            this.addProperty(property);
        }
    }

    @Override
    public List<MetaDataModelProperty> getProperties() {
        return this.metaDataModelPropertiesManager.getProperties();
    }

    @Override
    public boolean addProperty(MetaDataModelProperty metaDataModelProperty) {
        return this.metaDataModelPropertiesManager.addProperty(metaDataModelProperty);
    }

    @Override
    public boolean removeProperty(MetaDataModelProperty metaDataModelProperty) {
        return this.metaDataModelPropertiesManager.removeProperty(metaDataModelProperty);
    }

    @Override
    public boolean hasProperty(Class<? extends MetaDataModelProperty> metaDataModelProperty) {
        return this.metaDataModelPropertiesManager.hasProperty(metaDataModelProperty);
    }

    @Override
    public <T extends MetaDataModelProperty> T getProperty(Class<T> metaDataModelProperty) {
        return (T)((MetaDataModelProperty)this.metaDataModelPropertiesManager.getProperty(metaDataModelProperty));
    }

    @Override
    public String getImplementationClass() {
        return this.implementationClass != null ? this.implementationClass : this.inferImplementationClass();
    }

    private String inferImplementationClass() {
        return this.dataType.getDefaultImplementationClass();
    }

    public void setImplementationClass(String implementationClass) {
        this.implementationClass = implementationClass;
    }

    public String toString() {
        return "DefaultMetaDataModel:{ dataType:" + (Object)((Object)this.dataType) != null ? this.dataType.toString() : "null }";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractMetaDataModel)) {
            return false;
        }
        AbstractMetaDataModel other = (AbstractMetaDataModel)obj;
        return this.dataType == other.dataType;
    }
}

