/*
 * Decompiled with CFR 0.152.
 */
package org.mule.common.query.dsql.parser;

import java.util.HashMap;
import org.mule.common.query.expression.EqualsOperator;
import org.mule.common.query.expression.GreaterOperator;
import org.mule.common.query.expression.GreaterOrEqualsOperator;
import org.mule.common.query.expression.LessOperator;
import org.mule.common.query.expression.LessOrEqualsOperator;
import org.mule.common.query.expression.LikeOperator;
import org.mule.common.query.expression.NotEqualsOperator;
import org.mule.common.query.expression.Operator;

public final class QueryModelOperatorFactory {
    private static QueryModelOperatorFactory instance = new QueryModelOperatorFactory();
    private HashMap<String, Operator> operators = new HashMap();

    private QueryModelOperatorFactory() {
        this.operators.put("=", new EqualsOperator());
        this.operators.put(">", new GreaterOperator());
        this.operators.put("<", new LessOperator());
        this.operators.put(">=", new GreaterOrEqualsOperator());
        this.operators.put("<=", new LessOrEqualsOperator());
        this.operators.put("<>", new NotEqualsOperator());
    }

    public static QueryModelOperatorFactory getInstance() {
        return instance;
    }

    public Operator getOperator(String symbol) {
        if (symbol.equalsIgnoreCase("like")) {
            return new LikeOperator();
        }
        return this.operators.get(symbol);
    }
}

