/*
 * Decompiled with CFR 0.152.
 */
package org.mule.commons.atlantic.execution.builder.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.commons.atlantic.execution.context.ExecutionContext;
import org.mule.commons.atlantic.execution.context.exception.DefinedExceptionHandler;
import org.mule.commons.atlantic.execution.context.exception.ExceptionHandler;
import org.mule.commons.atlantic.execution.context.exception.PassThroughExceptionHandler;
import org.mule.commons.atlantic.execution.context.executor.BlockingExecutor;
import org.mule.commons.atlantic.execution.context.executor.Executor;
import org.mule.commons.atlantic.execution.context.listener.PostExecutionListener;
import org.mule.commons.atlantic.execution.context.listener.PreExecutionListener;

public class ExecutionBuilderFactory<SELF extends ExecutionBuilderFactory, RESULT> {
    private Executor executor = new BlockingExecutor();
    private List<PreExecutionListener> preExecutionListeners = new ArrayList<PreExecutionListener>();
    private List<PostExecutionListener> postExecutionListeners = new ArrayList<PostExecutionListener>();
    private List<DefinedExceptionHandler<?>> exceptionHandlers = new ArrayList();
    private Optional<DefinedExceptionHandler<?>> defaultExceptionHandler = Optional.empty();

    public SELF withExecutor(Executor<RESULT> executor) {
        this.executor = executor;
        return (SELF)this;
    }

    public SELF withPreExecutionListener(PreExecutionListener ... preExecutionListeners) {
        return this.addToList(this.preExecutionListeners, Stream.of(preExecutionListeners));
    }

    public SELF withPreExecutionListener(List<PreExecutionListener> preExecutionListeners) {
        return this.addToList(this.preExecutionListeners, preExecutionListeners.stream());
    }

    public SELF withPostExecutionListener(PostExecutionListener ... postExecutionListeners) {
        return this.addToList(this.postExecutionListeners, Stream.of(postExecutionListeners));
    }

    public SELF withPostExecutionListener(List<PostExecutionListener> postExecutionListeners) {
        return this.addToList(this.postExecutionListeners, postExecutionListeners.stream());
    }

    public <T extends Throwable> SELF withExceptionHandler(Class<T> exceptionClass, ExceptionHandler<T> exceptionHandler) {
        return this.withExceptionHandler(new DefinedExceptionHandler<T>(exceptionClass, exceptionHandler));
    }

    public <T extends Throwable> SELF withExceptionHandler(DefinedExceptionHandler<T> exceptionHandler) {
        return this.addToList(this.exceptionHandlers, Stream.of(exceptionHandler));
    }

    public <T extends Throwable> SELF withDefaultExceptionHandler(Class<T> exceptionClass, ExceptionHandler<T> exceptionHandler) {
        return this.withDefaultExceptionHandler(new DefinedExceptionHandler<T>(exceptionClass, exceptionHandler));
    }

    public <T extends Throwable> SELF withDefaultExceptionHandler(DefinedExceptionHandler<T> exceptionHandler) {
        this.defaultExceptionHandler = Optional.ofNullable(exceptionHandler);
        return (SELF)this;
    }

    public <T extends RuntimeException> SELF withIgnoredExceptionType(Class<T> exceptionClass) {
        Optional.ofNullable(exceptionClass).map(PassThroughExceptionHandler::new).ifPresent(handler -> this.exceptionHandlers.add(0, (DefinedExceptionHandler<?>)handler));
        return (SELF)this;
    }

    private <T> SELF addToList(List<T> list, Stream<T> elementsToAdd) {
        elementsToAdd.forEach(list::add);
        return (SELF)this;
    }

    protected ExecutionContext<RESULT> build() {
        if (this.defaultExceptionHandler.isPresent()) {
            this.exceptionHandlers.add(this.defaultExceptionHandler.get());
        }
        return new ExecutionContext(this.executor, this.preExecutionListeners, this.postExecutionListeners, this.exceptionHandlers);
    }
}

