/*
 * Decompiled with CFR 0.152.
 */
package org.mule.commons.atlantic.execution.context;

import java.util.Collections;
import java.util.List;
import org.mule.commons.atlantic.execution.context.exception.DefinedExceptionHandler;
import org.mule.commons.atlantic.execution.context.executor.Executor;
import org.mule.commons.atlantic.execution.context.listener.PostExecutionListener;
import org.mule.commons.atlantic.execution.context.listener.PreExecutionListener;
import org.mule.commons.atlantic.lambda.supplier.Supplier;

public class ExecutionContext<RESULT> {
    private final Executor<RESULT> executor;
    private final List<PreExecutionListener> preExecutionListeners;
    private final List<PostExecutionListener<RESULT>> postExecutionListeners;
    private final List<DefinedExceptionHandler<?>> exceptionHandlers;

    public ExecutionContext(Executor<RESULT> executor, List<PreExecutionListener> preExecutionListeners, List<PostExecutionListener<RESULT>> postExecutionListeners, List<DefinedExceptionHandler<?>> exceptionHandlers) {
        this.executor = executor;
        this.preExecutionListeners = Collections.unmodifiableList(preExecutionListeners);
        this.postExecutionListeners = Collections.unmodifiableList(postExecutionListeners);
        this.exceptionHandlers = Collections.unmodifiableList(exceptionHandlers);
    }

    public RESULT execute(Supplier<RESULT> operation, List<Object> params) {
        return this.executor.execute(operation, params, this.preExecutionListeners, this.postExecutionListeners, this.exceptionHandlers);
    }
}

