/*
 * Decompiled with CFR 0.152.
 */
package org.mule.commons.atlantic.execution.builder.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.commons.atlantic.exception.UnhandledException;
import org.mule.commons.atlantic.execution.ExecutionFactory;
import org.mule.commons.atlantic.execution.builder.factory.ExecutionFactoryBuilder;
import org.mule.commons.atlantic.execution.exception.handler.DefinedExceptionHandler;
import org.mule.commons.atlantic.execution.exception.handler.ExceptionHandler;
import org.mule.commons.atlantic.execution.exception.handler.PassThroughExceptionHandler;
import org.mule.commons.atlantic.execution.listener.OnPreExecutionListener;
import org.mule.commons.atlantic.execution.listener.OnSuccessListener;

public class DefaultExecutionFactoryBuilder<SELF extends DefaultExecutionFactoryBuilder>
implements ExecutionFactoryBuilder<SELF> {
    private List<OnPreExecutionListener> onPreExecutionListeners = new ArrayList<OnPreExecutionListener>();
    private List<OnSuccessListener> onSuccessListeners = new ArrayList<OnSuccessListener>();
    private List<DefinedExceptionHandler<?>> exceptionHandlers = new ArrayList();

    @Override
    public SELF withPreExecutionListener(OnPreExecutionListener ... onPreExecutionListeners) {
        return this.addToList(this.onPreExecutionListeners, Stream.of(onPreExecutionListeners));
    }

    @Override
    public SELF withPreExecutionListener(List<OnPreExecutionListener> onPreExecutionListeners) {
        return this.addToList(this.onPreExecutionListeners, onPreExecutionListeners.stream());
    }

    @Override
    public SELF withPostExecutionListener(OnSuccessListener ... onSuccessListeners) {
        return this.addToList(this.onSuccessListeners, Stream.of(onSuccessListeners));
    }

    @Override
    public SELF withPostExecutionListener(List<OnSuccessListener> postExecutionListeners) {
        return this.addToList(this.onSuccessListeners, postExecutionListeners.stream());
    }

    @Override
    public <T extends Throwable> SELF withExceptionHandler(Class<T> exceptionClass, ExceptionHandler<T> exceptionHandler) {
        return (SELF)this.withExceptionHandler((DefinedExceptionHandler)new DefinedExceptionHandler<T>(exceptionClass, exceptionHandler));
    }

    @Override
    public <T extends Throwable> SELF withExceptionHandler(DefinedExceptionHandler<T> exceptionHandler) {
        return this.addToList(this.exceptionHandlers, Stream.of(exceptionHandler));
    }

    @Override
    public <T extends RuntimeException> SELF withIgnoredExceptionType(Class<T> exceptionClass) {
        Optional.ofNullable(exceptionClass).map(PassThroughExceptionHandler::new).ifPresent(handler -> this.exceptionHandlers.add(0, (DefinedExceptionHandler<?>)handler));
        return (SELF)this;
    }

    private <T> SELF addToList(List<T> list, Stream<T> elementsToAdd) {
        elementsToAdd.forEach(list::add);
        return (SELF)this;
    }

    @Override
    public ExecutionFactory buildExecutionFactory() {
        return new ExecutionFactory(() -> this.onPreExecutionListeners.stream().forEach(OnPreExecutionListener::onPreExecution), result -> this.onSuccessListeners.stream().forEach(onSuccessListener -> onSuccessListener.onSuccess(result)), throwable -> this.exceptionHandlers.stream().filter(handler -> handler.getHandledException().isInstance(throwable)).findFirst().orElseThrow(() -> new UnhandledException(throwable)).handle(throwable));
    }
}

