/*
 * Decompiled with CFR 0.152.
 */
package org.mule.distributions.tests;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.distributions.tests.AbstractAppControl;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.tck.junit4.rule.EnvironmentVariable;

public class AppControlTestCase
extends AbstractAppControl {
    @Rule
    public EnvironmentVariable detailStatus = new EnvironmentVariable("DETAIL_STATUS", "true");
    private static final String SINGLE_APP_COMMAND = "-app";
    private static final String DEFAULT = "default";
    private static final String EMPTY_APP = "empty";

    @Before
    public void setup() {
        AppControlTestCase.getMule().deploy(AppControlTestCase.getResourceAsString("apps", EMPTY_APP));
    }

    @After
    public void tearDown() {
        AppControlTestCase.getMule().stop(new String[0]);
        AppControlTestCase.assertMuleStops();
    }

    @Test
    public void muleStarts() {
        AppControlTestCase.getMule().start(new String[0]);
        AppControlTestCase.assertMuleStarts();
        AppControlTestCase.assertAppIsDeployed(EMPTY_APP);
    }

    @Test
    public void stopShouldStopMule() {
        AppControlTestCase.getMule().start(new String[0]);
        AppControlTestCase.assertMuleStarts();
        AppControlTestCase.getMule().stop(new String[0]);
        AppControlTestCase.assertMuleStops();
    }

    @Test
    public void restartSpawnsANewProcess() {
        AppControlTestCase.getMule().start(new String[0]);
        int id = AppControlTestCase.getMule().getProcessId();
        AppControlTestCase.getMule().restart(new String[0]);
        AppControlTestCase.assertAppIsDeployed(EMPTY_APP);
        AppControlTestCase.assertMuleStarts();
        MatcherAssert.assertThat((Object)AppControlTestCase.getMule().getProcessId(), (Matcher)IsNot.not((Matcher)CoreMatchers.is((Object)id)));
    }

    @Test
    public void restartStartStoppedServer() {
        AppControlTestCase.getMule().restart(new String[0]);
        AppControlTestCase.assertAppIsDeployed(EMPTY_APP);
        AppControlTestCase.assertMuleStarts();
    }

    @Test
    public void deploySingleApplication() {
        AppControlTestCase.getMule().deploy(AppControlTestCase.getResourceAsString("apps", EMPTY_APP));
        AppControlTestCase.getMule().start(new String[]{SINGLE_APP_COMMAND, EMPTY_APP});
        AppControlTestCase.assertAppIsDeployed(EMPTY_APP);
        AppControlTestCase.assertAppNotDeployed(DEFAULT);
        AppControlTestCase.assertMuleStarts();
    }

    private static String getResourceAsString(String directory, String name) {
        return ClassUtils.getResource((String)(directory + "/" + name), AppControlTestCase.class).getPath();
    }
}

