/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.catalog.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

public class PrimitiveTypesTypeLoader
implements TypeLoader {
    public static final Map<String, MetadataType> PRIMITIVE_TYPES;
    public static final String STRING = "string";
    public static final String BOOLEAN = "boolean";
    public static final String NUMBER = "number";
    public static final String DATE = "date";
    public static final String DATETIME = "datetime";
    public static final String LOCALDATETIME = "localdatetime";
    public static final String TIME = "time";
    public static final String LOCALTIME = "localtime";
    public static final String TIMEZONE = "timezone";
    public static final String BINARY = "binary";
    public static final String ANY = "any";
    public static final String REGEX = "regex";

    @Override
    public Optional<MetadataType> load(String typeIdentifier) {
        return Optional.ofNullable(PRIMITIVE_TYPES.get(typeIdentifier));
    }

    static {
        HashMap<String, MetadataType> types = new HashMap<String, MetadataType>();
        types.put(STRING, BaseTypeBuilder.create(MetadataFormat.JAVA).stringType().build());
        types.put(BOOLEAN, BaseTypeBuilder.create(MetadataFormat.JAVA).booleanType().build());
        types.put(NUMBER, BaseTypeBuilder.create(MetadataFormat.JAVA).numberType().build());
        types.put(DATE, BaseTypeBuilder.create(MetadataFormat.JAVA).dateType().build());
        types.put(DATETIME, BaseTypeBuilder.create(MetadataFormat.JAVA).dateTimeType().build());
        types.put(LOCALDATETIME, BaseTypeBuilder.create(MetadataFormat.JAVA).localDateTimeType().build());
        types.put(TIME, BaseTypeBuilder.create(MetadataFormat.JAVA).timeType().build());
        types.put(LOCALTIME, BaseTypeBuilder.create(MetadataFormat.JAVA).localTimeType().build());
        types.put(TIMEZONE, BaseTypeBuilder.create(MetadataFormat.JAVA).timeZoneType().build());
        types.put(BINARY, BaseTypeBuilder.create(MetadataFormat.JAVA).binaryType().build());
        types.put(ANY, BaseTypeBuilder.create(MetadataFormat.JAVA).anyType().build());
        types.put(REGEX, BaseTypeBuilder.create(MetadataFormat.JAVA).regexType().build());
        PRIMITIVE_TYPES = Collections.unmodifiableMap(types);
    }
}

