/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java.internal.handler;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.ClassHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

public class MapClassHandler
implements ClassHandler {
    private static final Type[] EMPTY_ARRAY = new Type[0];

    @Override
    public boolean handles(Class<?> clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    @Override
    public TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes, TypeHandlerManager typeHandlerManager, ParsingContext context, BaseTypeBuilder typeBuilder) {
        ObjectTypeBuilder objectTypeBuilder = typeBuilder.objectType();
        Type type = this.getMapValueGeneric(clazz, genericTypes.toArray(new Type[genericTypes.size()]));
        if (this.mapValueShouldBeAnyType(type)) {
            objectTypeBuilder.open();
        } else {
            this.openWith(typeHandlerManager, context, objectTypeBuilder, type);
        }
        objectTypeBuilder.with(new ClassInformationAnnotation(clazz, genericTypes));
        return objectTypeBuilder;
    }

    private boolean mapValueShouldBeAnyType(Type type) {
        return type == null || type instanceof TypeVariable && (((TypeVariable)type).getBounds().length == 0 || ((TypeVariable)type).getBounds()[0].equals(Object.class));
    }

    private Type getMapValueGeneric(Class<?> clazz, Type[] genericTypes) {
        if (clazz.equals(Map.class)) {
            return genericTypes.length == 0 ? null : genericTypes[1];
        }
        TypeVariable[] unresolvedGenerics = clazz.getTypeParameters();
        if (clazz.getSuperclass() != null && Map.class.isAssignableFrom(clazz.getSuperclass())) {
            return this.getMapValueGenericFromSuperClass(clazz, genericTypes, unresolvedGenerics);
        }
        return this.getMapValueGenericFromImplementedInterface(clazz, genericTypes, unresolvedGenerics);
    }

    private Type getMapValueGenericFromImplementedInterface(Class<?> clazz, Type[] genericTypes, TypeVariable[] unresolvedGenerics) {
        int interfaceIndex;
        Class<?>[] interfaces = clazz.getInterfaces();
        for (interfaceIndex = 0; interfaceIndex < interfaces.length && !Map.class.isAssignableFrom(interfaces[interfaceIndex]); ++interfaceIndex) {
        }
        Type implementedInterface = clazz.getGenericInterfaces()[interfaceIndex];
        return this.getMapValueGenericFromGenericType(interfaces[interfaceIndex], implementedInterface, genericTypes, unresolvedGenerics);
    }

    private Type getMapValueGenericFromSuperClass(Class<?> clazz, Type[] genericTypes, TypeVariable[] unresolvedGenerics) {
        Class<?> superClazz = clazz.getSuperclass();
        Type genericSuperClazz = clazz.getGenericSuperclass();
        return this.getMapValueGenericFromGenericType(superClazz, genericSuperClazz, genericTypes, unresolvedGenerics);
    }

    private Type getMapValueGenericFromGenericType(Class<?> clazz, Type genericType, Type[] genericTypes, TypeVariable[] unresolvedGenerics) {
        Type returnType = this.getMapValueGeneric(clazz, genericType instanceof ParameterizedType ? ((ParameterizedType)genericType).getActualTypeArguments() : EMPTY_ARRAY);
        return this.resolveGenericType(genericTypes, unresolvedGenerics, returnType);
    }

    private Type resolveGenericType(Type[] resolvedGenericTypes, TypeVariable[] unresolvedGenerics, Type typeToResolve) {
        if (!(typeToResolve instanceof TypeVariable)) {
            return typeToResolve;
        }
        int resolutionIndex = 0;
        for (TypeVariable unResolvedGeneric : unresolvedGenerics) {
            if (unResolvedGeneric.equals(typeToResolve)) break;
            ++resolutionIndex;
        }
        if (resolutionIndex >= unresolvedGenerics.length) {
            return Object.class;
        }
        return resolvedGenericTypes.length == 0 ? unresolvedGenerics[resolutionIndex] : resolvedGenericTypes[resolutionIndex];
    }

    private void openWith(TypeHandlerManager typeHandlerManager, ParsingContext context, ObjectTypeBuilder objectTypeBuilder, Type type) {
        Optional<TypeBuilder<?>> keyTypeBuilder = context.getTypeBuilder(type);
        if (keyTypeBuilder.isPresent()) {
            objectTypeBuilder.openWith(keyTypeBuilder.get());
        } else {
            typeHandlerManager.handle(type, context, objectTypeBuilder.openWith());
        }
    }
}

