/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.handler;

import org.everit.json.schema.NumberSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.json.api.handler.HandlerManager;
import org.mule.metadata.json.api.handler.ParsingContext;
import org.mule.metadata.json.api.handler.SchemaHandler;

public class NumberHandler
implements SchemaHandler {
    @Override
    public boolean handles(Schema schema) {
        return schema instanceof NumberSchema;
    }

    @Override
    public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager, ParsingContext parsingContext) {
        NumberSchema numberSchema = (NumberSchema)schema;
        NumberTypeBuilder numberType = root.numberType();
        Number min = null;
        Number max = null;
        if (numberSchema.getMinimum() != null) {
            min = numberSchema.getMinimum();
        }
        if (numberSchema.getMaximum() != null) {
            max = numberSchema.getMaximum();
        }
        if (MetadataTypeUtils.isNotNull(min) || MetadataTypeUtils.isNotNull(max)) {
            numberType.range(min, max);
        }
        if (numberSchema.requiresInteger()) {
            numberType.integer();
        }
        return numberType;
    }
}

