/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.message.api;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectFieldTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.impl.BaseMetadataType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MuleEventMetadataType;

class DefaultMuleEventMetadataType
extends BaseMetadataType
implements ObjectType,
MuleEventMetadataType {
    public static final String MESSAGE_FIELD_NAME = "message";
    public static final String ERROR_FIELD_NAME = "error";
    public static final String VARIABLES_FIELD_NAME = "variables";
    private final ObjectFieldType messageMetadataType;
    private final ObjectFieldType variables;
    private final ObjectFieldType errorFieldType;
    private static final Field[] REFLECTION_FIELDS;

    DefaultMuleEventMetadataType(MessageMetadataType messageMetadataType, ObjectType variables, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        this(messageMetadataType, null, variables, annotations);
    }

    DefaultMuleEventMetadataType(MessageMetadataType messageMetadataType, MetadataType errorType, ObjectType variables, Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
        super(MetadataFormat.JAVA, annotations);
        ObjectFieldTypeBuilder messageTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
        messageTypeBuilder.key(MESSAGE_FIELD_NAME).value(messageMetadataType);
        messageTypeBuilder.required(true);
        this.messageMetadataType = messageTypeBuilder.build();
        if (errorType != null) {
            ObjectFieldTypeBuilder errorTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
            errorTypeBuilder.key(ERROR_FIELD_NAME).value(errorType);
            errorTypeBuilder.required(true);
            this.errorFieldType = errorTypeBuilder.build();
        } else {
            this.errorFieldType = null;
        }
        ObjectFieldTypeBuilder variablesTypeBuilder = new ObjectFieldTypeBuilder(MetadataFormat.JAVA);
        variablesTypeBuilder.required(true);
        variablesTypeBuilder.key(VARIABLES_FIELD_NAME).value(variables);
        this.variables = variablesTypeBuilder.build();
    }

    private Optional<ObjectFieldType> getErrorFieldType() {
        return Optional.ofNullable(this.errorFieldType);
    }

    @Override
    public MessageMetadataType getMessageType() {
        return (MessageMetadataType)this.messageMetadataType.getValue();
    }

    @Override
    public Optional<MetadataType> getErrorType() {
        return this.getErrorFieldType().map(ObjectFieldType::getValue);
    }

    @Override
    public ObjectType getVariables() {
        return (ObjectType)this.variables.getValue();
    }

    @Override
    public Optional<MetadataType> getVariableType(String varName) {
        return this.getVariables().getFieldByName(varName).map(ObjectFieldType::getValue);
    }

    @Override
    public Optional<MetadataType> getOpenRestriction() {
        return Optional.empty();
    }

    @Override
    public Collection<ObjectFieldType> getFields() {
        ArrayList<ObjectFieldType> objectFieldTypes = new ArrayList<ObjectFieldType>();
        objectFieldTypes.add(this.messageMetadataType);
        this.getErrorFieldType().ifPresent(objectFieldTypes::add);
        objectFieldTypes.add(this.variables);
        return objectFieldTypes;
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public Optional<ObjectFieldType> getFieldByName(String name) {
        switch (name) {
            case "message": {
                return Optional.ofNullable(this.messageMetadataType);
            }
            case "error": {
                return this.getErrorFieldType();
            }
            case "variables": {
                return Optional.ofNullable(this.variables);
            }
        }
        return Optional.empty();
    }

    @Override
    public void accept(MetadataTypeVisitor metadataTypeVisitor) {
        metadataTypeVisitor.visitObject(this);
    }

    @Override
    public Field[] getReflectionComparableFields() {
        return REFLECTION_FIELDS;
    }

    static {
        try {
            REFLECTION_FIELDS = (Field[])ArrayUtils.addAll((Object[])BASE_REFLECTION_FIELDS, (Object[])new Field[]{DefaultMuleEventMetadataType.class.getDeclaredField("messageMetadataType"), DefaultMuleEventMetadataType.class.getDeclaredField(VARIABLES_FIELD_NAME), DefaultMuleEventMetadataType.class.getDeclaredField("errorFieldType")});
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Could not resolve field", e);
        }
    }
}

