/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence.serializer;

import com.google.gson.stream.JsonWriter;
import java.util.Stack;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.api.model.BooleanType;
import org.mule.metadata.api.model.DateTimeType;
import org.mule.metadata.api.model.DateType;
import org.mule.metadata.api.model.FunctionType;
import org.mule.metadata.api.model.IntersectionType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NothingType;
import org.mule.metadata.api.model.NullType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.TimeType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.persistence.ObjectTypeReferenceHandler;
import org.mule.metadata.persistence.serializer.ArrayTypeSerializer;
import org.mule.metadata.persistence.serializer.FunctionTypeSerializer;
import org.mule.metadata.persistence.serializer.IntersectionTypeSerializer;
import org.mule.metadata.persistence.serializer.ObjectTypeSerializer;
import org.mule.metadata.persistence.serializer.SimpleTypeSerializer;
import org.mule.metadata.persistence.serializer.TupleTypeSerializer;
import org.mule.metadata.persistence.serializer.TypeReferenceSerializer;
import org.mule.metadata.persistence.serializer.TypeSerializer;
import org.mule.metadata.persistence.serializer.UnionTypeSerializer;

public class TypeSerializerVisitor
extends MetadataTypeVisitor
implements TypeSerializer<MetadataType> {
    private final JsonWriter writer;
    private final ObjectTypeReferenceHandler handler;
    private Stack<MetadataType> typeStack;
    private final SimpleTypeSerializer anyTypeSerializer;
    private final TypeReferenceSerializer referenceSerializer;
    private final ArrayTypeSerializer arrayTypeSerializer;
    private final SimpleTypeSerializer binaryTypeSerializer;
    private final SimpleTypeSerializer booleanTypeSerializer;
    private final SimpleTypeSerializer dateTimeSerializer;
    private final SimpleTypeSerializer dateSerializer;
    private final SimpleTypeSerializer nullTypeSerializer;
    private final SimpleTypeSerializer nothingTypeSerializer;
    private final SimpleTypeSerializer voidTypeSerializer;
    private final ObjectTypeSerializer objectTypeSerializer;
    private final SimpleTypeSerializer stringTypeSerializer;
    private final SimpleTypeSerializer timeTypeSerializer;
    private final TupleTypeSerializer tupleTypeSerializer;
    private final FunctionTypeSerializer functionTypeSerializer;
    private final UnionTypeSerializer unionTypeSerializer;
    private final IntersectionTypeSerializer intersectionTypeSerializer;

    public TypeSerializerVisitor(JsonWriter writer, ObjectTypeReferenceHandler handler, Stack<MetadataType> typeStack, boolean formatOnReferences) {
        this.writer = writer;
        this.handler = handler;
        this.typeStack = typeStack;
        this.anyTypeSerializer = new SimpleTypeSerializer("Any");
        this.binaryTypeSerializer = new SimpleTypeSerializer("Binary");
        this.booleanTypeSerializer = new SimpleTypeSerializer("Boolean");
        this.dateTimeSerializer = new SimpleTypeSerializer("DateTime");
        this.dateSerializer = new SimpleTypeSerializer("Date");
        this.nullTypeSerializer = new SimpleTypeSerializer("Null");
        this.nothingTypeSerializer = new SimpleTypeSerializer("Nothing");
        this.voidTypeSerializer = new SimpleTypeSerializer("Void");
        this.stringTypeSerializer = new SimpleTypeSerializer("String");
        this.timeTypeSerializer = new SimpleTypeSerializer("Time");
        this.arrayTypeSerializer = new ArrayTypeSerializer(this);
        this.objectTypeSerializer = new ObjectTypeSerializer(this);
        this.tupleTypeSerializer = new TupleTypeSerializer(this);
        this.functionTypeSerializer = new FunctionTypeSerializer(this);
        this.unionTypeSerializer = new UnionTypeSerializer(this);
        this.intersectionTypeSerializer = new IntersectionTypeSerializer(this);
        this.referenceSerializer = new TypeReferenceSerializer(handler, formatOnReferences);
    }

    @Override
    public void serialize(JsonWriter writer, MetadataType type, Stack<MetadataType> typeStack) {
        this.typeStack = typeStack;
        type.accept(this);
    }

    @Override
    public void visitAnyType(AnyType anyType) {
        this.anyTypeSerializer.serialize(this.writer, anyType, this.typeStack);
    }

    @Override
    public void visitArrayType(ArrayType arrayType) {
        this.arrayTypeSerializer.serialize(this.writer, arrayType, this.typeStack);
    }

    @Override
    public void visitBinaryType(BinaryType binaryType) {
        this.binaryTypeSerializer.serialize(this.writer, binaryType, this.typeStack);
    }

    @Override
    public void visitBoolean(BooleanType booleanType) {
        this.booleanTypeSerializer.serialize(this.writer, booleanType, this.typeStack);
    }

    @Override
    public void visitDateTime(DateTimeType dateTimeType) {
        this.dateTimeSerializer.serialize(this.writer, dateTimeType, this.typeStack);
    }

    @Override
    public void visitDate(DateType dateType) {
        this.dateSerializer.serialize(this.writer, dateType, this.typeStack);
    }

    @Override
    public void visitNull(NullType nullType) {
        this.nullTypeSerializer.serialize(this.writer, nullType, this.typeStack);
    }

    @Override
    public void visitNothing(NothingType nothingType) {
        this.nothingTypeSerializer.serialize(this.writer, nothingType, this.typeStack);
    }

    @Override
    public void visitVoid(VoidType voidType) {
        this.voidTypeSerializer.serialize(this.writer, voidType, this.typeStack);
    }

    @Override
    public void visitNumber(NumberType numberType) {
        new SimpleTypeSerializer("Number").serialize(this.writer, numberType, this.typeStack);
    }

    @Override
    public void visitObject(ObjectType objectType) {
        if (!this.typeStack.contains(objectType) && this.handler.shouldWriteReference(objectType)) {
            this.referenceSerializer.serialize(this.writer, objectType, this.typeStack);
            return;
        }
        this.objectTypeSerializer.serialize(this.writer, objectType, this.typeStack);
    }

    @Override
    public void visitString(StringType stringType) {
        this.stringTypeSerializer.serialize(this.writer, stringType, this.typeStack);
    }

    @Override
    public void visitTime(TimeType timeType) {
        this.timeTypeSerializer.serialize(this.writer, timeType, this.typeStack);
    }

    @Override
    public void visitTuple(TupleType tupleType) {
        this.tupleTypeSerializer.serialize(this.writer, tupleType, this.typeStack);
    }

    @Override
    public void visitFunction(FunctionType functionType) {
        this.functionTypeSerializer.serialize(this.writer, functionType, this.typeStack);
    }

    @Override
    public void visitUnion(UnionType unionType) {
        this.unionTypeSerializer.serialize(this.writer, unionType, this.typeStack);
    }

    @Override
    public void visitIntersection(IntersectionType intersectionType) {
        this.intersectionTypeSerializer.serialize(this.writer, intersectionType, this.typeStack);
    }
}

