/*
 * Decompiled with CFR 0.152.
 */
package org.mule.mvel2.ast;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.mule.mvel2.CompileException;
import org.mule.mvel2.ParserContext;
import org.mule.mvel2.ast.ASTNode;
import org.mule.mvel2.integration.VariableResolverFactory;
import org.mule.mvel2.util.ArrayTools;

public class StaticImportNode
extends ASTNode {
    private Class declaringClass;
    private String methodName;
    private transient Method method;

    public StaticImportNode(char[] expr, int start, int offset, ParserContext pCtx) {
        super(pCtx);
        try {
            this.expr = expr;
            this.start = start;
            this.offset = offset;
            ClassLoader classLoader = this.getClassLoader();
            this.expr = expr;
            int mark = ArrayTools.findLast('.', start, offset, expr);
            this.declaringClass = Class.forName(new String(expr, start, mark - start), true, classLoader);
            this.methodName = new String(expr, ++mark, offset - (mark - start));
            if (this.resolveMethod() == null) {
                throw new CompileException("can not find method for static import: " + this.declaringClass.getName() + "." + this.methodName, expr, start);
            }
        }
        catch (Exception e) {
            throw new CompileException("unable to import class", expr, start, e);
        }
    }

    private Method resolveMethod() {
        for (Method meth : this.declaringClass.getMethods()) {
            if (!Modifier.isStatic(meth.getModifiers()) || !this.methodName.equals(meth.getName())) continue;
            this.method = meth;
            return this.method;
        }
        return null;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        factory.createVariable(this.methodName, this.method == null ? (this.method = this.resolveMethod()) : this.method);
        return null;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        return this.getReducedValueAccelerated(ctx, thisValue, factory);
    }
}

