/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jgrapht.Graph;
import org.jgrapht.traverse.TopologicalOrderIterator;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.ast.graph.internal.ComponentAstEdge;
import org.mule.runtime.ast.graph.internal.cycle.GraphCycleRemover;
import org.mule.runtime.ast.internal.FilteredArtifactAst;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultArtifactAstDependencyGraph
implements ArtifactAstDependencyGraph {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultArtifactAstDependencyGraph.class);
    private final ArtifactAst source;
    private final Graph<ComponentAst, ComponentAstEdge> graph;
    private final Map<ComponentAst, Set<ComponentAst>> transitiveDependenciesCache = new HashMap<ComponentAst, Set<ComponentAst>>();
    private final Set<ComponentAstDependency> missingDependencies;
    private LazyValue<List<ComponentAst>> dependenciesFirstList;

    public DefaultArtifactAstDependencyGraph(ArtifactAst source, Graph<ComponentAst, ComponentAstEdge> graph, Set<ComponentAstDependency> missingDependencies) {
        this.source = source;
        this.graph = graph;
        this.missingDependencies = missingDependencies;
        this.dependenciesFirstList = new LazyValue<Supplier<List>>(() -> {
            List topLevelComponents = source.topLevelComponentsStream().collect(Collectors.toList());
            Comparator comparator = (o1, o2) -> {
                int c2Index;
                int c1Index = topLevelComponents.indexOf(o1);
                if (c1Index > (c2Index = topLevelComponents.indexOf(o2))) {
                    return 1;
                }
                if (c1Index < c2Index) {
                    return -1;
                }
                return 0;
            };
            GraphCycleRemover graphCycleRemover = new GraphCycleRemover(graph, comparator);
            ArrayList componentAsts = Lists.newArrayList((Iterator)new TopologicalOrderIterator(graphCycleRemover.removeCycles()));
            Collections.reverse(componentAsts);
            return componentAsts;
        });
    }

    @Override
    public ArtifactAst minimalArtifactFor(ComponentAst vertex) {
        Set<ComponentAst> requiredComponents = this.findVertexDependenciesWithVertex(vertex);
        this.logResolvedMinimal(vertex, requiredComponents);
        return new FilteredArtifactAst(this.source, requiredComponents::contains);
    }

    @Override
    public ArtifactAst minimalArtifactFor(Predicate<ComponentAst> vertexPredicate) {
        Set<ComponentAst> requiredComponents = this.source.filteredComponents(vertexPredicate).flatMap(vertex -> this.findVertexDependenciesWithVertex((ComponentAst)vertex).stream()).collect(Collectors.toSet());
        this.logResolvedMinimal(vertexPredicate, requiredComponents);
        return new FilteredArtifactAst(this.source, requiredComponents::contains);
    }

    @Override
    public Set<ComponentAst> getRequiredComponents(String componentName) {
        Set<ComponentAst> requiredComponents = this.source.recursiveStream().filter(this.isComponentName(componentName)).findFirst().map(vertex -> this.findVertexDependenciesWithVertex((ComponentAst)vertex).stream().collect(Collectors.toSet())).orElse(Collections.emptySet());
        this.logResolvedMinimal(this.isComponentName(componentName), requiredComponents);
        return requiredComponents;
    }

    private Predicate<ComponentAst> isComponentName(String componentName) {
        return x -> x.getComponentId().map(name -> name.equals(componentName)).orElse(false);
    }

    @Override
    public Set<ComponentAstDependency> getMissingDependencies() {
        return this.missingDependencies;
    }

    private Set<ComponentAst> findVertexDependenciesWithVertex(ComponentAst vertex) {
        HashSet<ComponentAst> requiredComponents = new HashSet<ComponentAst>(this.findVertexDependencies(vertex));
        requiredComponents.add(vertex);
        return requiredComponents;
    }

    private Set<ComponentAst> findVertexDependencies(ComponentAst vertex) {
        return this.transitiveDependenciesCache.computeIfAbsent(vertex, comp -> {
            LOGGER.trace("> Processing vertex '{}'...", (Object)vertex);
            return this.graph.outgoingEdgesOf((Object)vertex).stream().flatMap(outgoingEdge -> {
                Stream<ComponentAst> transitiveOutgoingDependenciesOf = outgoingEdge.transitiveOutgoingDependenciesOf(this.graph);
                if (LOGGER.isTraceEnabled()) {
                    Set<ComponentAst> deps = transitiveOutgoingDependenciesOf.collect(Collectors.toSet());
                    LOGGER.trace("> Transitive outgoing deps:");
                    deps.forEach(rq -> LOGGER.debug("    '{}'", rq));
                    transitiveOutgoingDependenciesOf = deps.stream();
                }
                return Stream.concat(Stream.of(outgoingEdge.getTarget()), transitiveOutgoingDependenciesOf);
            }).collect(Collectors.toSet());
        });
    }

    private void logResolvedMinimal(Object vertexPredicate, Set<ComponentAst> requiredComponents) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Minimal artifact for '{}' contains:", vertexPredicate);
            requiredComponents.forEach(rq -> LOGGER.debug("    '{}'", rq));
        }
    }

    @Override
    public Comparator<ComponentAst> dependencyComparator() {
        return (c1, c2) -> {
            int c2Index;
            List<ComponentAst> dependenciesFirstIndex = this.dependenciesFirstList.get();
            int c1Index = dependenciesFirstIndex.indexOf(c1);
            if (c1Index > (c2Index = dependenciesFirstIndex.indexOf(c2))) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("dependencyComparator('{}' > '{}')", c1, c2);
                }
                return 1;
            }
            if (c1Index < c2Index) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("dependencyComparator('{}' < '{}')", c1, c2);
                }
                return -1;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("dependencyComparator('{}' == '{}')", c1, c2);
            }
            return 0;
        };
    }
}

