/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.internal.builder.PropertiesResolver;

public final class DefaultArtifactAst
extends BaseArtifactAst {
    private final List<ComponentAst> topLevelComponents;
    private final Supplier<Set<ExtensionModel>> dependenciesSupplier;
    private final ArtifactAst parentArtifact;
    private final PropertiesResolver propertiesResolver;
    private final NamespaceDefinition namespaceDefinition;
    private final List<ImportedResource> importedResources;

    public DefaultArtifactAst(List<ComponentAst> topLevelComponents, Supplier<Set<ExtensionModel>> dependenciesSupplier, ArtifactAst parentArtifact, PropertiesResolver propertiesResolver, NamespaceDefinition namespaceDefinition, List<ImportedResource> importedResources) {
        this.topLevelComponents = topLevelComponents;
        this.dependenciesSupplier = new LazyValue<Supplier<Set>>(() -> DependencyResolutionMode.getDependencyResolutionMode().resolveDependencies(dependenciesSupplier, this));
        this.parentArtifact = parentArtifact;
        this.propertiesResolver = propertiesResolver;
        this.namespaceDefinition = namespaceDefinition;
        this.importedResources = importedResources;
    }

    @Override
    public Set<ExtensionModel> dependencies() {
        return this.dependenciesSupplier.get();
    }

    @Override
    public Optional<ArtifactAst> getParent() {
        return Optional.ofNullable(this.parentArtifact);
    }

    @Override
    public List<ComponentAst> topLevelComponents() {
        return this.topLevelComponents;
    }

    @Override
    public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
        this.propertiesResolver.setMappingFunction(newPropertiesResolver);
    }

    @Override
    public NamespaceDefinition namespaceDefinition() {
        return this.namespaceDefinition;
    }

    @Override
    public Collection<ImportedResource> getImportedResources() {
        return this.importedResources;
    }
}

