/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompositeErrorTypeRepository
implements ErrorTypeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeErrorTypeRepository.class);
    private final List<ErrorTypeRepository> children;

    public CompositeErrorTypeRepository(List<ErrorTypeRepository> children) {
        this.children = children;
    }

    @Override
    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        for (ErrorTypeRepository child : this.children) {
            Optional<ErrorType> lookupErrorType = child.lookupErrorType(errorTypeComponentIdentifier);
            if (!lookupErrorType.isPresent()) continue;
            return lookupErrorType;
        }
        if (Boolean.getBoolean("mule.errorTypes.lax")) {
            LOGGER.warn("Could not find error '{}'.", (Object)errorTypeComponentIdentifier);
            return Optional.of(ErrorTypeBuilder.builder().namespace(errorTypeComponentIdentifier.getNamespace()).identifier(errorTypeComponentIdentifier.getName()).parentErrorType(this.getAnyErrorType()).build());
        }
        return Optional.empty();
    }

    @Override
    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        for (ErrorTypeRepository child : this.children) {
            Optional<ErrorType> getErrorType = child.getErrorType(errorTypeIdentifier);
            if (!getErrorType.isPresent()) continue;
            return getErrorType;
        }
        return Optional.empty();
    }

    @Override
    public Collection<String> getErrorNamespaces() {
        return this.children.stream().flatMap(c -> c.getErrorNamespaces().stream()).collect(Collectors.toSet());
    }

    @Override
    public ErrorType getAnyErrorType() {
        for (ErrorTypeRepository child : this.children) {
            ErrorType anyErrorType = child.getAnyErrorType();
            if (anyErrorType == null) continue;
            return anyErrorType;
        }
        return null;
    }

    @Override
    public ErrorType getSourceErrorType() {
        for (ErrorTypeRepository child : this.children) {
            ErrorType sourceErrorType = child.getSourceErrorType();
            if (sourceErrorType == null) continue;
            return sourceErrorType;
        }
        return null;
    }

    @Override
    public ErrorType getSourceResponseErrorType() {
        for (ErrorTypeRepository child : this.children) {
            ErrorType sourceResponseErrorType = child.getSourceResponseErrorType();
            if (sourceResponseErrorType == null) continue;
            return sourceResponseErrorType;
        }
        return null;
    }

    @Override
    public ErrorType getCriticalErrorType() {
        for (ErrorTypeRepository child : this.children) {
            ErrorType criticalErrorType = child.getCriticalErrorType();
            if (criticalErrorType == null) continue;
            return criticalErrorType;
        }
        return null;
    }

    @Override
    public Set<ErrorType> getErrorTypes() {
        return this.children.stream().flatMap(repo -> repo.getErrorTypes().stream()).collect(Collectors.toSet());
    }

    @Override
    public Set<ErrorType> getInternalErrorTypes() {
        return this.children.stream().flatMap(repo -> repo.getInternalErrorTypes().stream()).collect(Collectors.toSet());
    }
}

