/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;

public class ConfigurationDependencyResolver {
    private final ArtifactAstDependencyGraph appModelDependencyGraph;

    public ConfigurationDependencyResolver(ArtifactAst applicationModel) {
        this.appModelDependencyGraph = ArtifactAstDependencyGraphFactory.generateFor(applicationModel);
    }

    public ConfigurationDependencyResolver(ArtifactAstDependencyGraph graph) {
        this.appModelDependencyGraph = graph;
    }

    public Collection<String> resolveComponentDependencies(String componentName) {
        return this.appModelDependencyGraph.minimalArtifactFor(new ComponentNamePredicate(componentName)).recursiveStream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).filter(name -> !name.equals(componentName)).collect(Collectors.toList());
    }

    public Collection<String> getDirectComponentDependencies(String componentName) {
        return this.appModelDependencyGraph.getRequiredComponents(componentName).stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private static class ComponentNamePredicate
    implements Predicate<ComponentAst> {
        private final String componentName;

        public ComponentNamePredicate(String componentName) {
            this.componentName = componentName;
        }

        @Override
        public boolean test(ComponentAst comp) {
            return comp.getComponentId().map(n -> n.equals(this.componentName)).orElse(false);
        }

        public String toString() {
            return "componentName='" + this.componentName + "'";
        }
    }
}

