/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.error;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.internal.error.ErrorTypeBuilder;
import org.mule.runtime.core.api.error.Errors;

public final class MuleCoreErrorTypeRepository
implements ErrorTypeRepository {
    private static final ErrorType ANY_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("ANY").build();
    private static final ErrorType SOURCE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("SOURCE").parentErrorType(ANY_ERROR_TYPE).build();
    private static final ErrorType SOURCE_RESPONSE_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("SOURCE_RESPONSE").parentErrorType(SOURCE_ERROR_TYPE).build();
    private static final ErrorType UNKNOWN_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("UNKNOWN").parentErrorType(ANY_ERROR_TYPE).build();
    public static final ErrorType CRITICAL_ERROR_TYPE = ErrorTypeBuilder.builder().namespace(Errors.CORE_NAMESPACE_NAME).identifier("CRITICAL").parentErrorType(null).build();
    public static final ErrorTypeRepository MULE_CORE_ERROR_TYPE_REPOSITORY = new MuleCoreErrorTypeRepository();
    private final Map<ComponentIdentifier, ErrorType> errorTypes = new HashMap<ComponentIdentifier, ErrorType>();
    private final Map<ComponentIdentifier, ErrorType> internalErrorTypes = new HashMap<ComponentIdentifier, ErrorType>();

    private MuleCoreErrorTypeRepository() {
        this.errorTypes.put(Errors.ComponentIdentifiers.Handleable.ANY, ANY_ERROR_TYPE);
        this.errorTypes.put(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE, SOURCE_RESPONSE_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Handleable.SOURCE, SOURCE_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Unhandleable.CRITICAL, CRITICAL_ERROR_TYPE);
        this.internalErrorTypes.put(Errors.ComponentIdentifiers.Handleable.UNKNOWN, UNKNOWN_ERROR_TYPE);
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.TRANSFORMATION, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.EXPRESSION, this.getAnyErrorType());
        ErrorType validationErrorType = this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.VALIDATION, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.DUPLICATE_MESSAGE, validationErrorType);
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.REDELIVERY_EXHAUSTED, this.getAnyErrorType());
        ErrorType connectivityErrorType = this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.CONNECTIVITY, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.RETRY_EXHAUSTED, connectivityErrorType);
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.CLIENT_SECURITY, this.getErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).get());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY, this.getErrorType(Errors.ComponentIdentifiers.Handleable.SECURITY).get());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.NOT_PERMITTED, this.getErrorType(Errors.ComponentIdentifiers.Handleable.SERVER_SECURITY).get());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.STREAM_MAXIMUM_SIZE_EXCEEDED, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.TRANSACTION, this.getAnyErrorType());
        this.doAddInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD, this.getCriticalErrorType());
        this.doAddInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.FLOW_BACK_PRESSURE, this.getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).get());
        this.doAddInternalErrorType(Errors.ComponentIdentifiers.Unhandleable.FATAL, this.getCriticalErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.TIMEOUT, this.getAnyErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.COMPOSITE_ROUTING, this.getErrorType(Errors.ComponentIdentifiers.Handleable.ROUTING).get());
        ErrorType sourceErrorType = this.getSourceErrorType();
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_GENERATE, this.getSourceResponseErrorType());
        this.doAddErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_RESPONSE_SEND, this.getSourceResponseErrorType());
        this.doAddInternalErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_GENERATE, sourceErrorType);
        this.doAddInternalErrorType(Errors.ComponentIdentifiers.Handleable.SOURCE_ERROR_RESPONSE_SEND, sourceErrorType);
    }

    @Override
    public ErrorType addErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ErrorType addInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        throw new UnsupportedOperationException();
    }

    private ErrorType doAddErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.errorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    private ErrorType doAddInternalErrorType(ComponentIdentifier errorTypeIdentifier, ErrorType parentErrorType) {
        ErrorType errorType = this.buildErrorType(errorTypeIdentifier, parentErrorType);
        this.internalErrorTypes.put(errorTypeIdentifier, errorType);
        return errorType;
    }

    private ErrorType buildErrorType(ComponentIdentifier identifier, ErrorType parent) {
        if (this.errorTypes.containsKey(identifier) || this.internalErrorTypes.containsKey(identifier)) {
            throw new IllegalStateException(String.format("An error type with identifier '%s' already exists", identifier));
        }
        return ErrorTypeBuilder.builder().namespace(identifier.getNamespace()).identifier(identifier.getName()).parentErrorType(parent).build();
    }

    @Override
    public Optional<ErrorType> lookupErrorType(ComponentIdentifier errorTypeComponentIdentifier) {
        return Optional.ofNullable(this.errorTypes.get(errorTypeComponentIdentifier));
    }

    @Override
    public Optional<ErrorType> getErrorType(ComponentIdentifier errorTypeIdentifier) {
        Optional<ErrorType> errorType = this.lookupErrorType(errorTypeIdentifier);
        if (!errorType.isPresent()) {
            errorType = Optional.ofNullable(this.internalErrorTypes.get(errorTypeIdentifier));
        }
        return errorType;
    }

    @Override
    public Collection<String> getErrorNamespaces() {
        return Collections.singleton(Errors.CORE_NAMESPACE_NAME);
    }

    @Override
    public ErrorType getAnyErrorType() {
        return ANY_ERROR_TYPE;
    }

    @Override
    public ErrorType getSourceErrorType() {
        return SOURCE_ERROR_TYPE;
    }

    @Override
    public ErrorType getSourceResponseErrorType() {
        return SOURCE_RESPONSE_ERROR_TYPE;
    }

    @Override
    public ErrorType getCriticalErrorType() {
        return CRITICAL_ERROR_TYPE;
    }

    @Override
    public Set<ErrorType> getErrorTypes() {
        return new HashSet<ErrorType>(this.errorTypes.values());
    }

    @Override
    public Set<ErrorType> getInternalErrorTypes() {
        return new HashSet<ErrorType>(this.internalErrorTypes.values());
    }
}

