/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.factories;

import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.tx.TransactionType;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.transaction.MuleTransactionConfig;
import org.mule.runtime.core.internal.processor.TryScope;
import org.mule.runtime.core.internal.transaction.TransactionFactoryLocator;
import org.springframework.beans.factory.FactoryBean;

public class TryProcessorFactoryBean
extends AbstractComponent
implements FactoryBean<TryScope> {
    protected List messageProcessors;
    protected FlowExceptionHandler exceptionListener;
    protected String transactionalAction;
    private TransactionType transactionType;
    @Inject
    private TransactionFactoryLocator transactionFactoryLocator;

    public Class getObjectType() {
        return TryScope.class;
    }

    public void setMessageProcessors(List messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public TryScope getObject() throws Exception {
        TryScope txProcessor = new TryScope();
        txProcessor.setAnnotations(this.getAnnotations());
        txProcessor.setExceptionListener(this.exceptionListener);
        txProcessor.setTransactionConfig(this.createTransactionConfig(this.transactionalAction, this.transactionType));
        txProcessor.setMessageProcessors(this.messageProcessors == null ? Collections.emptyList() : this.messageProcessors);
        return txProcessor;
    }

    protected MuleTransactionConfig createTransactionConfig(String action, TransactionType type) {
        MuleTransactionConfig transactionConfig = new MuleTransactionConfig();
        transactionConfig.setActionAsString(action);
        transactionConfig.setFactory(this.transactionFactoryLocator.lookUpTransactionFactory(type).orElseThrow(() -> new IllegalArgumentException(String.format("Unable to create Try Scope with a Transaction Type: [%s]. No factory available for this transaction type", new Object[]{type}))));
        return transactionConfig;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setExceptionListener(FlowExceptionHandler exceptionListener) {
        this.exceptionListener = exceptionListener;
    }

    public void setTransactionalAction(String action) {
        this.transactionalAction = action;
    }

    public void setTransactionType(TransactionType transactionType) {
        this.transactionType = transactionType;
    }
}

