/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpansionModulesModel;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public abstract class ApplicationModel {
    public static final String ERROR_MAPPING = "error-mapping";
    public static final String ON_ERROR = "on-error";
    public static final String WHEN_CHOICE_ES_ATTRIBUTE = "when";
    public static final String TYPE_ES_ATTRIBUTE = "type";
    public static final String PROPERTY_ELEMENT = "property";
    public static final String NAME_ATTRIBUTE = "name";
    public static final String REFERENCE_ATTRIBUTE = "ref";
    public static final String VALUE_ATTRIBUTE = "value";
    public static final String DESCRIPTION_ELEMENT = "description";
    public static final String PROPERTIES_ELEMENT = "properties";
    public static final String REDELIVERY_POLICY_ELEMENT = "redelivery-policy";
    public static final String TEST_NAMESPACE = "test";
    public static final String DOC_NAMESPACE = "doc";
    public static final String GLOBAL_PROPERTY = "global-property";
    public static final String SECURITY_MANAGER = "security-manager";
    public static final String OBJECT_ELEMENT = "object";
    public static final ComponentIdentifier ERROR_MAPPING_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-mapping").build();
    public static final ComponentIdentifier ON_ERROR_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error").build();
    public static final ComponentIdentifier MULE_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("property").build();
    public static final ComponentIdentifier MULE_PROPERTIES_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("properties").build();
    public static final ComponentIdentifier ANNOTATIONS_ELEMENT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("annotations").build();
    public static final ComponentIdentifier DOC_DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().namespace("doc").name("description").build();
    public static final ComponentIdentifier DESCRIPTION_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("description").build();
    public static final ComponentIdentifier OBJECT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("object").build();
    public static final ComponentIdentifier REDELIVERY_POLICY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("redelivery-policy").build();
    public static final ComponentIdentifier GLOBAL_PROPERTY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("global-property").build();
    public static final ComponentIdentifier SECURITY_MANAGER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("security-manager").build();
    public static final ComponentIdentifier SCHEDULING_STRATEGY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("scheduling-strategy").build();
    public static final ComponentIdentifier FIXED_FREQUENCY_STRATEGY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("fixed-frequency").build();
    public static final ComponentIdentifier CRON_STRATEGY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("cron").build();
    public static final ComponentIdentifier TLS_CONTEXT_IDENTIFIER = ComponentIdentifier.builder().namespace("tls").name("context").build();
    public static final ComponentIdentifier TLS_REVOCATION_CHECK_IDENTIFIER = ComponentIdentifier.builder().namespace("tls").name("revocation-check").build();
    public static final ComponentIdentifier POOLING_PROFILE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("pooling-profile").build();
    public static final ComponentIdentifier EXPIRATION_POLICY_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("expiration-policy").build();
    public static final ComponentIdentifier RECONNECT_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("reconnect").build();
    public static final ComponentIdentifier RECONNECT_FOREVER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("reconnect-forever").build();
    public static final ComponentIdentifier RECONNECTION_CONFIG_PARAMETER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("reconnection").build();
    public static final ComponentIdentifier REPEATABLE_IN_MEMORY_STREAM_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("repeatable-in-memory-stream").build();
    public static final ComponentIdentifier REPEATABLE_FILE_STORE_STREAM_IDENTIFIER = ComponentIdentifier.builder().namespace("ee").name("repeatable-file-store-stream").build();
    public static final ComponentIdentifier NON_REPEATABLE_STREAM_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("non-repeatable-stream").build();
    public static final ComponentIdentifier REPEATABLE_IN_MEMORY_ITERABLE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("repeatable-in-memory-iterable").build();
    public static final ComponentIdentifier REPEATABLE_FILE_STORE_ITERABLE_IDENTIFIER = ComponentIdentifier.builder().namespace("ee").name("repeatable-file-store-iterable").build();
    public static final ComponentIdentifier NON_REPEATABLE_ITERABLE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("non-repeatable-iterable").build();

    public static ArtifactAst prepareAstForRuntime(ArtifactAst ast, Set<ExtensionModel> extensionModels) {
        ast = ApplicationModel.processSourcesRedeliveryPolicy(ast);
        ast = ApplicationModel.doXmlSdk1MacroExpansion(ast, extensionModels);
        return ast;
    }

    private static ArtifactAst doXmlSdk1MacroExpansion(ArtifactAst ast, Set<ExtensionModel> extensionModels) {
        return new MacroExpansionModulesModel(ast, extensionModels).expand();
    }

    private static ArtifactAst processSourcesRedeliveryPolicy(ArtifactAst ast) {
        return MuleArtifactAstCopyUtils.copyRecursively(ast, flow -> {
            if (!CoreDslConstants.FLOW_IDENTIFIER.equals(flow.getIdentifier())) {
                return flow;
            }
            return flow.directChildrenStream().findFirst().filter(comp -> comp.getModel(SourceModel.class).isPresent()).flatMap(comp -> ExtensionModelUtils.getGroupAndParametersPairs(comp.getModel(SourceModel.class).get()).filter(pairGroupSource -> {
                ComponentParameterAst redeliveryPolicyParam = comp.getParameter(((ParameterGroupModel)pairGroupSource.getFirst()).getName(), "redeliveryPolicy");
                if (redeliveryPolicyParam != null) {
                    ComponentAst redeliveryPolicy = (ComponentAst)redeliveryPolicyParam.getValue().getRight();
                    return redeliveryPolicy != null;
                }
                return false;
            }).map(pairGroupSource -> {
                ComponentAst redeliveryPolicy = (ComponentAst)comp.getParameter(((ParameterGroupModel)pairGroupSource.getFirst()).getName(), "redeliveryPolicy").getValue().getRight();
                return ApplicationModel.transformFlowWithRedeliveryPolicy(flow, comp, redeliveryPolicy);
            }).findFirst()).orElse(flow);
        });
    }

    private static ComponentAst transformFlowWithRedeliveryPolicy(final ComponentAst flow, ComponentAst source, final ComponentAst redeliveryPolicy) {
        final ArrayList<BaseComponentAstDecorator> newFlowChildren = new ArrayList<BaseComponentAstDecorator>();
        newFlowChildren.add(new BaseComponentAstDecorator(source){

            @Override
            public Stream<ComponentAst> directChildrenStream() {
                return super.directChildrenStream().filter(sourceChild -> sourceChild != redeliveryPolicy);
            }

            @Override
            public ComponentParameterAst getParameter(String groupName, String paramName) {
                if ("redeliveryPolicy".equals(paramName)) {
                    return null;
                }
                return this.getDecorated().getParameter(groupName, paramName);
            }

            @Override
            public Collection<ComponentParameterAst> getParameters() {
                return this.getDecorated().getParameters().stream().filter(p -> !p.getModel().getName().equals("redeliveryPolicy")).collect(Collectors.toList());
            }
        });
        newFlowChildren.add(new BaseComponentAstDecorator(redeliveryPolicy){

            @Override
            public Stream<ComponentAst> directChildrenStream() {
                return flow.directChildrenStream().filter(comp -> !comp.getModel(SourceModel.class).isPresent() && !CoreDslConstants.ERROR_HANDLER_IDENTIFIER.equals(comp.getIdentifier()));
            }
        });
        flow.directChildrenStream().filter(comp -> CoreDslConstants.ERROR_HANDLER_IDENTIFIER.equals(comp.getIdentifier())).forEach(newFlowChildren::add);
        return new BaseComponentAstDecorator(flow){

            @Override
            public Stream<ComponentAst> directChildrenStream() {
                return newFlowChildren.stream();
            }
        };
    }

    public static Optional<ComponentAst> findComponentDefinitionModel(ArtifactAst ast, ComponentIdentifier componentIdentifier) {
        return ast.topLevelComponentsStream().filter(componentModel -> componentModel.getIdentifier().equals(componentIdentifier)).findFirst();
    }
}

