/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public class ErrorHandlerRefOrOnErrorExclusiveness
implements Validation {
    private static final String ERROR_HANDLER = "error-handler";
    private static final String REFERENCE_ATTRIBUTE = "ref";
    private final ComponentIdentifier ERROR_HANDLER_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("error-handler").build();

    @Override
    public String getName() {
        return "'error-handler': 'ref' or 'on-error' exclusiveness";
    }

    @Override
    public String getDescription() {
        return "A reference error-handler cannot have on-errors.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(ComponentAstPredicatesFactory.equalsIdentifier(this.ERROR_HANDLER_IDENTIFIER));
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        ComponentParameterAst refParam = component.getParameter("General", REFERENCE_ATTRIBUTE);
        if (refParam.getValue().getValue().isPresent() && component.directChildrenStream().count() > 0L) {
            return Optional.of(ValidationResultItem.create(component, refParam, (Validation)this, "A reference 'error-handler' cannot have 'on-error's."));
        }
        return Optional.empty();
    }
}

