/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.connectivity.internal.platform.schema.generator;

import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.connectivity.api.platform.schema.extension.ExcludeFromConnectivitySchemaModelProperty;
import org.mule.runtime.connectivity.api.platform.schema.generator.ConnectivitySchemaGenerator;
import org.mule.runtime.connectivity.api.platform.schema.generator.ConnectivitySchemaGeneratorBuilder;
import org.mule.runtime.connectivity.internal.platform.schema.generator.DefaultConnectivitySchemaGenerator;

public class DefaultConnectivitySchemaGeneratorBuilder
implements ConnectivitySchemaGeneratorBuilder {
    private Function<ConnectionProviderModel, Set<String>> connectionTermsExtractor;
    private Function<ParameterModel, Set<String>> parameterTermsExtractor;
    private Function<MetadataType, Set<String>> typeTermsExtractor;
    private Function<ConnectionProviderModel, Boolean> connectionPredicate;
    private BiFunction<ConnectionProviderModel, ParameterModel, Boolean> parameterPredicate;

    @Override
    public ConnectivitySchemaGeneratorBuilder setConnectionTermsExtractor(Function<ConnectionProviderModel, Set<String>> connectionTermsExtractor) {
        this.connectionTermsExtractor = connectionTermsExtractor;
        return this;
    }

    @Override
    public ConnectivitySchemaGeneratorBuilder setParameterTermsExtractor(Function<ParameterModel, Set<String>> parameterTermsExtractor) {
        this.parameterTermsExtractor = parameterTermsExtractor;
        return this;
    }

    @Override
    public ConnectivitySchemaGeneratorBuilder setTypeTermsExtractor(Function<MetadataType, Set<String>> typeTermsExtractor) {
        this.typeTermsExtractor = typeTermsExtractor;
        return this;
    }

    @Override
    public ConnectivitySchemaGeneratorBuilder setConnectionPredicate(Function<ConnectionProviderModel, Boolean> predicate) {
        this.connectionPredicate = predicate;
        return this;
    }

    @Override
    public ConnectivitySchemaGeneratorBuilder setParameterPredicate(BiFunction<ConnectionProviderModel, ParameterModel, Boolean> predicate) {
        this.parameterPredicate = predicate;
        return this;
    }

    @Override
    public ConnectivitySchemaGenerator build() {
        Preconditions.checkState(this.connectionTermsExtractor != null, "Specifying a connectionTermsExtractor is mandatory");
        Preconditions.checkState(this.parameterTermsExtractor != null, "Specifying a parameterTermsExtractor is mandatory");
        Preconditions.checkState(this.typeTermsExtractor != null, "Specifying a typeTermsExtractor is mandatory");
        return new DefaultConnectivitySchemaGenerator(this.connectionTermsExtractor, this.parameterTermsExtractor, this.typeTermsExtractor, this.getConnectionPredicate(), this.getParameterPredicate());
    }

    private Function<ConnectionProviderModel, Boolean> getConnectionPredicate() {
        return this.connectionPredicate != null ? this.connectionPredicate : model -> !model.getModelProperty(ExcludeFromConnectivitySchemaModelProperty.class).isPresent();
    }

    private BiFunction<ConnectionProviderModel, ParameterModel, Boolean> getParameterPredicate() {
        return this.parameterPredicate != null ? this.parameterPredicate : (c, p) -> !p.getModelProperty(ExcludeFromConnectivitySchemaModelProperty.class).isPresent();
    }
}

