/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.event;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.core.api.construct.FlowConstruct;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.internal.event.DefaultEventContext;

public interface EventContextFactory {
    public static EventContext create(FlowConstruct flow, ComponentLocation location) {
        return EventContextFactory.create(flow, location, null);
    }

    public static EventContext create(FlowConstruct flow, ComponentLocation location, String correlationId) {
        return EventContextFactory.create(flow, location, correlationId, Optional.empty());
    }

    @Deprecated
    public static EventContext create(String id, String serverId, ComponentLocation location, FlowExceptionHandler exceptionHandler) {
        return EventContextFactory.create(id, serverId, location, null, exceptionHandler);
    }

    @Deprecated
    public static EventContext create(String id, String serverId, ComponentLocation location, String correlationId, FlowExceptionHandler exceptionHandler) {
        return EventContextFactory.create(id, serverId, location, correlationId, Optional.empty(), exceptionHandler);
    }

    public static EventContext create(FlowConstruct flow, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        return new DefaultEventContext(flow, location, correlationId, externalCompletion);
    }

    @Deprecated
    public static EventContext create(FlowConstruct flow, FlowExceptionHandler exceptionHandler, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        return new DefaultEventContext(flow, exceptionHandler, location, correlationId, externalCompletion);
    }

    public static EventContext create(String id, String serverId, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion) {
        return new DefaultEventContext(id, serverId, location, correlationId, externalCompletion);
    }

    @Deprecated
    public static EventContext create(String id, String serverId, ComponentLocation location, String correlationId, Optional<CompletableFuture<Void>> externalCompletion, FlowExceptionHandler exceptionHandler) {
        return new DefaultEventContext(id, serverId, location, correlationId, externalCompletion, exceptionHandler);
    }
}

