/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.processor;

import javax.inject.Inject;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.TypedException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.api.el.ExtendedExpressionManager;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.privileged.util.AttributeEvaluator;

public final class RaiseErrorProcessor
extends AbstractComponent
implements Processor,
Initialisable {
    private static final String ERROR_MESSAGE = "An error occurred.";
    private AttributeEvaluator descriptionEvaluator = new AttributeEvaluator("An error occurred.", DataType.STRING);
    private String typeId;
    private ErrorType errorType;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ExtendedExpressionManager expressionManager;

    @Override
    public void initialise() throws InitialisationException {
        if (StringUtils.isEmpty(this.typeId)) {
            throw new InitialisationException(I18nMessageFactory.createStaticMessage("type cannot be an empty string or null"), (Initialisable)this);
        }
        ComponentIdentifier errorTypeComponentIdentifier = ComponentIdentifier.buildFromStringRepresentation(this.typeId);
        this.errorType = this.errorTypeRepository.lookupErrorType(errorTypeComponentIdentifier).orElseThrow(() -> new InitialisationException(I18nMessageFactory.createStaticMessage(String.format("Could not find error '%s'.", this.typeId)), (Initialisable)this));
        this.descriptionEvaluator.initialize(this.expressionManager);
    }

    @Override
    public CoreEvent process(CoreEvent event) throws MuleException {
        String message = (String)this.descriptionEvaluator.resolveValue(event);
        throw new TypedException(new DefaultMuleException(message), this.errorType);
    }

    public void setType(String type) {
        this.typeId = type;
    }

    public void setDescription(String description) {
        this.descriptionEvaluator = new AttributeEvaluator(description, DataType.STRING);
    }
}

