/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.retry.policy;

import java.io.InterruptedIOException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.inject.Inject;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.management.stats.AllStatistics;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryNotifier;
import org.mule.runtime.core.api.retry.policy.ConnectNotifier;
import org.mule.runtime.core.api.retry.policy.PolicyStatus;
import org.mule.runtime.core.api.retry.policy.RetryPolicy;
import org.mule.runtime.core.api.retry.policy.RetryPolicyExhaustedException;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.retry.DefaultRetryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public abstract class AbstractPolicyTemplate
extends AbstractComponent
implements RetryPolicyTemplate {
    protected RetryNotifier notifier = new ConnectNotifier();
    private Map<Object, Object> metaInfo;
    @Inject
    private NotificationDispatcher notificationFirer;
    @Inject
    protected MuleContext muleContext;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPolicyTemplate.class);

    @Override
    public RetryContext execute(RetryCallback callback, Executor workManager) throws Exception {
        PolicyStatus status = null;
        RetryPolicy policy = this.createRetryInstance();
        DefaultRetryContext context = new DefaultRetryContext(callback.getWorkDescription(), this.metaInfo, this.notificationFirer);
        try {
            Exception cause = null;
            while (true) {
                try {
                    callback.doWork(context);
                    if (this.notifier == null) break;
                    this.notifier.onSuccess(context);
                }
                catch (Exception e) {
                    cause = e;
                    this.computeStats();
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Error executing policy", (Throwable)cause);
                    }
                    if (this.notifier != null) {
                        this.notifier.onFailure(context, cause);
                    }
                    if (!(cause instanceof InterruptedException) && !(cause instanceof InterruptedIOException)) continue;
                    LOGGER.error("Process was interrupted (InterruptedException), ceasing process");
                    break;
                    if ((status = policy.applyPolicy(cause)).isOk()) continue;
                }
                break;
            }
            if (status == null || status.isOk()) {
                DefaultRetryContext defaultRetryContext = context;
                return defaultRetryContext;
            }
            context.setFailed(cause);
            throw new RetryPolicyExhaustedException(cause, callback.getWorkOwner());
        }
        finally {
            if (status != null && status.getThrowable() != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Error executing policy", status.getThrowable());
            }
        }
    }

    protected void computeStats() {
        AllStatistics statistics = this.muleContext.getStatistics();
        if (statistics != null && statistics.isEnabled() && this.computeConnectionErrorsInStats()) {
            statistics.getApplicationStatistics().incConnectionErrors();
        }
    }

    protected boolean computeConnectionErrorsInStats() {
        return this.featureFlaggingService.isEnabled(MuleRuntimeFeature.COMPUTE_CONNECTION_ERRORS_IN_STATS);
    }

    @Override
    public RetryNotifier getNotifier() {
        return this.notifier;
    }

    @Override
    public void setNotifier(RetryNotifier retryNotifier) {
        this.notifier = retryNotifier;
    }

    @Override
    public Map<Object, Object> getMetaInfo() {
        return this.metaInfo;
    }

    @Override
    public void setMetaInfo(Map<Object, Object> metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setId(String id) {
    }

    public void setNotificationFirer(NotificationDispatcher notificationFirer) {
        this.notificationFirer = notificationFirer;
    }
}

