/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.el.mvel.datatype;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.mule.mvel2.compiler.CompiledExpression;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.core.internal.el.mvel.datatype.ExpressionDataTypeResolver;
import org.mule.runtime.core.internal.el.mvel.datatype.FlowVarExpressionDataTypeResolver;
import org.mule.runtime.core.internal.el.mvel.datatype.PayloadExpressionDataTypeResolver;
import org.mule.runtime.core.internal.el.mvel.datatype.PropertyExpressionDataTypeResolver;
import org.mule.runtime.core.internal.el.mvel.datatype.SessionVarExpressionDataTypeResolver;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;

public class MvelDataTypeResolver {
    private final List<ExpressionDataTypeResolver> resolvers;

    public MvelDataTypeResolver() {
        this(MvelDataTypeResolver.getDefaultDataTypeResolvers());
    }

    public MvelDataTypeResolver(List<ExpressionDataTypeResolver> resolvers) {
        this.resolvers = new LinkedList<ExpressionDataTypeResolver>(resolvers);
    }

    private static List<ExpressionDataTypeResolver> getDefaultDataTypeResolvers() {
        LinkedList<ExpressionDataTypeResolver> resolvers = new LinkedList<ExpressionDataTypeResolver>();
        resolvers.add(new PayloadExpressionDataTypeResolver());
        resolvers.add(new PropertyExpressionDataTypeResolver());
        resolvers.add(new FlowVarExpressionDataTypeResolver());
        resolvers.add(new SessionVarExpressionDataTypeResolver());
        return resolvers;
    }

    public DataType resolve(Object value, PrivilegedEvent event, Serializable serializedExpression) {
        DataType result = null;
        if (serializedExpression instanceof CompiledExpression) {
            ExpressionDataTypeResolver resolver;
            CompiledExpression compiledExpression = (CompiledExpression)serializedExpression;
            Iterator<ExpressionDataTypeResolver> iterator = this.resolvers.iterator();
            while (iterator.hasNext() && (result = (resolver = iterator.next()).resolve(event, compiledExpression)) == null) {
            }
        }
        if (result == null) {
            Class type = value == null ? Object.class : value.getClass();
            result = DataType.fromType(type);
        }
        return result;
    }
}

